% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_single_dose_dataset.R
\name{create_single_dose_dataset}
\alias{create_single_dose_dataset}
\title{Create dataset of single doses}
\usage{
create_single_dose_dataset(
  dataset,
  dose_freq = EXDOSFRQ,
  start_date = ASTDT,
  start_datetime = NULL,
  end_date = AENDT,
  end_datetime = NULL,
  lookup_table = dose_freq_lookup,
  lookup_column = CDISC_VALUE,
  keep_source_vars = quo_c(vars(USUBJID), dose_freq, start_date, start_datetime,
    end_date, end_datetime)
)
}
\arguments{
\item{dataset}{Input dataset

The columns specified by \code{dose_freq}, \code{start_date} and the \code{end_date}
parameters are expected.}

\item{dose_freq}{The dose frequency

The aggregate dosing frequency used for multiple doses in a row.

Permitted Values: defined by lookup table.}

\item{start_date}{The start date

A date object is expected. This object cannot contain \code{NA} values.

Refer to \code{derive_vars_dt()} to impute and derive a date from a date
character vector to a date object.}

\item{start_datetime}{The start date-time

A date-time object is expected. This object cannot contain \code{NA} values.

Refer to \code{derive_vars_dtm()} to impute and derive a date-time from a date
character vector to a date object.

If the input dataset contains frequencies which refer to \code{DOSE_WINDOW}
equals \code{"HOUR"} or \code{"MINUTE"}, the parameter must be specified.}

\item{end_date}{The end date

A date or date-time object is expected. This object cannot contain \code{NA} values.

Refer to \code{derive_vars_dt()} to impute and derive a date from a date
character vector to a date object.}

\item{end_datetime}{The end date-time

A date-time object is expected. This object cannot contain \code{NA} values.

Refer to \code{derive_vars_dtm()} to impute and derive a date-time from a date
character vector to a date object.

If the input dataset contains frequencies which refer to \code{DOSE_WINDOW}
equals \code{"HOUR"} or \code{"MINUTE"}, the parameter must be specified.}

\item{lookup_table}{The dose frequency value lookup table

The table used to look up \code{dose_freq} values and determine the appropriate
multiplier to be used for row generation. If a lookup table other than the
default is used, it must have columns \code{DOSE_WINDOW}, \code{DOSE_COUNT}, and
\code{CONVERSION_FACTOR}. The default table \code{dose_freq_lookup} is described in
detail \link[=dose_freq_lookup]{here}.

Permitted Values for \code{DOSE_WINDOW}: \code{"MINUTE"}, \code{"HOUR"}, \code{"DAY"},
\code{"WEEK"}, \code{"MONTH"}, \code{"YEAR"}}

\item{lookup_column}{The dose frequency value column in the lookup table

The column of \code{lookup_table}.}

\item{keep_source_vars}{List of variables to be retained from source dataset

This parameter can be specified if additional information is required in
the output dataset. For example \code{EXTRT} for studies with more than one
drug.}
}
\value{
The input dataset with a single dose per row.
}
\description{
Derives dataset of single dose from aggregate dose information. This may be
necessary when e.g. calculating last dose before an adverse event in \code{ADAE}
or deriving a total dose parameter in \code{ADEX} when \code{EXDOSFRQ != ONCE}.
}
\details{
Each aggregate dose row is split into multiple rows which each
represent a single dose.The number of completed dose periods between
\code{start_date} or \code{start_datetime} and \code{end_date} or \code{end_datetime} is
calculated with \code{compute_duration} and multiplied by \code{DOSE_COUNT}.
For \code{DOSE_WINDOW} values of \code{"WEEK"}, \code{"MONTH"}, and \code{"YEAR"},
\code{CONVERSION_FACTOR} is used to convert into days the time object
to be added to \code{start_date}.

Observations with dose frequency \code{"ONCE"} are copied to the output dataset
unchanged.
}
\examples{
# Example with default lookup

library(lubridate)
library(stringr)
library(tibble)

data <- tribble(
  ~USUBJID, ~EXDOSFRQ, ~ASTDT, ~ASTDTM, ~AENDT, ~AENDTM,
  "P01", "Q2D", ymd("2021-01-01"), ymd_hms("2021-01-01 10:30:00"),
  ymd("2021-01-07"), ymd_hms("2021-01-07 11:30:00"),
  "P01", "Q3D", ymd("2021-01-08"), ymd_hms("2021-01-08 12:00:00"),
  ymd("2021-01-14"), ymd_hms("2021-01-14 14:00:00"),
  "P01", "EVERY 2 WEEKS", ymd("2021-01-15"), ymd_hms("2021-01-15 09:57:00"),
  ymd("2021-01-29"), ymd_hms("2021-01-29 10:57:00")
)

create_single_dose_dataset(data)


# Example with custom lookup

custom_lookup <- tribble(
  ~Value,   ~DOSE_COUNT, ~DOSE_WINDOW, ~CONVERSION_FACTOR,
  "Q30MIN", (1 / 30),    "MINUTE",                      1,
  "Q90MIN", (1 / 90),    "MINUTE",                      1
)

data <- tribble(
  ~USUBJID, ~EXDOSFRQ, ~ASTDT, ~ASTDTM, ~AENDT, ~AENDTM,
  "P01", "Q30MIN", ymd("2021-01-01"), ymd_hms("2021-01-01T06:00:00"),
  ymd("2021-01-01"), ymd_hms("2021-01-01T07:00:00"),
  "P02", "Q90MIN", ymd("2021-01-01"), ymd_hms("2021-01-01T06:00:00"),
  ymd("2021-01-01"), ymd_hms("2021-01-01T09:00:00")
)

create_single_dose_dataset(data,
  lookup_table = custom_lookup,
  lookup_column = Value,
  start_datetime = ASTDTM,
  end_datetime = AENDTM
)
}
\seealso{
Creating auxiliary datasets: 
\code{\link{create_period_dataset}()},
\code{\link{create_query_data}()}
}
\author{
Michael Thorpe, Andrew Smith
}
\concept{create_aux}
\keyword{create_aux}
