% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/derive_param_tte.R
\name{derive_param_tte}
\alias{derive_param_tte}
\title{Derive a Time-to-Event Parameter}
\usage{
derive_param_tte(
  dataset = NULL,
  dataset_adsl,
  source_datasets,
  by_vars = NULL,
  start_date = TRTSDT,
  event_conditions,
  censor_conditions,
  create_datetime = FALSE,
  set_values_to,
  subject_keys = get_admiral_option("subject_keys")
)
}
\arguments{
\item{dataset}{Input dataset

The \code{PARAMCD} variable is expected.}

\item{dataset_adsl}{ADSL input dataset

The variables specified for \code{start_date}, \code{start_imputation_flag}, and
\code{subject_keys} are expected.}

\item{source_datasets}{Source datasets

A named list of datasets is expected. The \code{dataset_name} field of
\code{tte_source()} refers to the dataset provided in the list.}

\item{by_vars}{By variables

If the parameter is specified, separate time to event parameters are
derived for each by group.

The by variables must be in at least one of the source datasets. Each
source dataset must contain either all by variables or none of the by
variables.

The by variables are not included in the output dataset.}

\item{start_date}{Time to event origin date

The variable \code{STARTDT} is set to the specified date. The value is taken
from the ADSL dataset.

If the event or censoring date is before the origin date, \code{ADT} is set to
the origin date.

If the specified variable is imputed, the corresponding date imputation
flag must specified for \code{start_imputation_flag}.}

\item{event_conditions}{Sources and conditions defining events

A list of \code{event_source()} objects is expected.}

\item{censor_conditions}{Sources and conditions defining censorings

A list of \code{censor_source()} objects is expected.}

\item{create_datetime}{Create datetime variables?

If set to \code{TRUE}, variables \code{ADTM} and \code{STARTDTM} are created. Otherwise,
variables \code{ADT} and \code{STARTDT} are created.}

\item{set_values_to}{Variables to set

A named list returned by \code{vars()} defining the variables to be set for the
new parameter, e.g. \code{vars(PARAMCD = "OS", PARAM = "Overall Survival")} is
expected. The values must be symbols, character strings, numeric values,
expressions, or \code{NA}.}

\item{subject_keys}{Variables to uniquely identify a subject

A list of symbols created using \code{vars()} is expected.}
}
\value{
The input dataset with the new parameter added
}
\description{
Add a time-to-event parameter to the input dataset.
}
\details{
The following steps are performed to create the observations of the
new parameter:

\strong{Deriving the events:}

\enumerate{ \item For each event source dataset the observations as
specified by the \code{filter} element are selected. Then for each patient the
first observation (with respect to \code{date}) is selected.

\item The \code{ADT} variable is set to the variable specified by the
\code{date} element. If the date variable is a datetime variable, only
the datepart is copied.

\item The \code{CNSR} variable is added and set to the \code{censor} element.

\item The variables specified by the \code{set_values_to} element are
added.

\item The selected observations of all event source datasets are combined into a
single dataset.

\item For each patient the first observation (with respect to the \code{ADT}
variable) from the single dataset is selected. }

\strong{Deriving the censoring observations:}

\enumerate{ \item For each censoring source dataset the observations as
specified by the \code{filter} element are selected. Then for each patient the
last observation (with respect to \code{date}) is selected.

\item The \code{ADT} variable is set to the variable specified by the
\code{date} element. If the date variable is a datetime variable, only
the datepart is copied.

\item The \code{CNSR} variable is added and set to the \code{censor} element.

\item The variables specified by the \code{set_values_to} element are
added.

\item The selected observations of all censoring source datasets are
combined into a single dataset.

\item For each patient the last observation (with respect to the \code{ADT}
variable) from the single dataset is selected. }

For each subject (as defined by the \code{subject_keys} parameter) an
observation is selected. If an event is available, the event observation is
selected. Otherwise the censoring observation is selected.

Finally
\enumerate{
\item the variables specified for \code{start_date} and \code{start_imputation_flag} are
joined from the ADSL dataset,
\item the variables as defined by the \code{set_values_to} parameter are added,
\item the \code{ADT}/\code{ADTM} variable is set to the maximum of \code{ADT}/\code{ADTM} and
\code{STARTDT}/\code{STARTDTM} (depending on the \code{create_datetime} parameter), and
\item the new observations are added to the output dataset.
}
}
\examples{
library(tibble)
library(dplyr, warn.conflicts = FALSE)
library(lubridate)
data("admiral_adsl")

adsl <- admiral_adsl

death <- event_source(
  dataset_name = "adsl",
  filter = DTHFL == "Y",
  date = DTHDT,
  set_values_to = vars(
    EVNTDESC = "DEATH",
    SRCDOM = "ADSL",
    SRCVAR = "DTHDT"
  )
)

last_alive_dt <- censor_source(
  dataset_name = "adsl",
  date = LSTALVDT,
  set_values_to = vars(
    EVNTDESC = "LAST DATE KNOWN ALIVE",
    SRCDOM = "ADSL",
    SRCVAR = "LSTALVDT"
  )
)

derive_param_tte(
  dataset_adsl = adsl,
  event_conditions = list(death),
  censor_conditions = list(last_alive_dt),
  source_datasets = list(adsl = adsl),
  set_values_to = vars(
    PARAMCD = "OS",
    PARAM = "Overall Survival"
  )
) \%>\%
  select(-STUDYID) \%>\%
  filter(row_number() \%in\% 20:30)

# derive time to adverse event for each preferred term #
adsl <- tribble(
  ~USUBJID, ~TRTSDT,           ~EOSDT,
  "01",     ymd("2020-12-06"), ymd("2021-03-06"),
  "02",     ymd("2021-01-16"), ymd("2021-02-03")
) \%>\%
  mutate(STUDYID = "AB42")

ae <- tribble(
  ~USUBJID, ~AESTDTC,           ~AESEQ, ~AEDECOD,
  "01",     "2021-01-03T10:56", 1,      "Flu",
  "01",     "2021-03-04",       2,      "Cough",
  "01",     "2021",             3,      "Flu"
) \%>\%
  mutate(STUDYID = "AB42")

ae_ext <- derive_vars_dt(
  ae,
  dtc = AESTDTC,
  new_vars_prefix = "AEST",
  highest_imputation = "M",
  flag_imputation = "none"
)

ttae <- event_source(
  dataset_name = "ae",
  date = AESTDT,
  set_values_to = vars(
    EVNTDESC = "AE",
    SRCDOM = "AE",
    SRCVAR = "AESTDTC",
    SRCSEQ = AESEQ
  )
)

eos <- censor_source(
  dataset_name = "adsl",
  date = EOSDT,
  set_values_to = vars(
    EVNTDESC = "END OF STUDY",
    SRCDOM = "ADSL",
    SRCVAR = "EOSDT"
  )
)

derive_param_tte(
  dataset_adsl = adsl,
  by_vars = vars(AEDECOD),
  start_date = TRTSDT,
  event_conditions = list(ttae),
  censor_conditions = list(eos),
  source_datasets = list(adsl = adsl, ae = ae_ext),
  set_values_to = vars(
    PARAMCD = paste0("TTAE", as.numeric(as.factor(AEDECOD))),
    PARAM = paste("Time to First", AEDECOD, "Adverse Event"),
    PARCAT1 = "TTAE",
    PARCAT2 = AEDECOD
  )
) \%>\%
  select(USUBJID, STARTDT, PARAMCD, PARAM, ADT, CNSR, SRCSEQ)
}
\author{
Stefan Bundfuss
}
\concept{der_prm_tte}
\keyword{der_prm_tte}
