% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/derive_joined.R
\name{get_joined_data}
\alias{get_joined_data}
\title{Join Data for "joined" functions}
\usage{
get_joined_data(
  dataset,
  dataset_add,
  by_vars = NULL,
  join_vars = NULL,
  join_type,
  first_cond_lower = NULL,
  first_cond_upper = NULL,
  order = NULL,
  tmp_obs_nr_var = NULL,
  filter_add = NULL,
  filter_join = NULL,
  check_type = "warning"
)
}
\arguments{
\item{dataset}{Input dataset

The variables specified by the \code{by_vars} argument are expected to be in the dataset.}

\item{dataset_add}{Additional dataset

The variables specified by the \code{by_vars}, the \code{new_vars}, the \code{join_vars},
and the \code{order} argument are expected.}

\item{by_vars}{Grouping variables

The two datasets are joined by the specified variables.

Variables can be renamed by naming the element, i.e.
\verb{by_vars = exprs(<name in input dataset> = <name in additional dataset>)}, similar to the \code{dplyr} joins.

\emph{Permitted Values}: list of variables created by \code{exprs()}
e.g. \code{exprs(USUBJID, VISIT)}}

\item{join_vars}{Variables to use from additional dataset

Any extra variables required from the additional dataset for \code{filter_join}
should be specified for this argument. Variables specified for \code{new_vars}
do not need to be repeated for \code{join_vars}. If a specified variable exists
in both the input dataset and the additional dataset, the suffix ".join" is
added to the variable from the additional dataset.

If an expression is named, e.g., \code{exprs(EXTDT = convert_dtc_to_dt(EXSTDTC))}, a corresponding variable is added to the
additional dataset and can be used in the filter conditions (\code{filter_add},
\code{filter_join}) and for \code{new_vars}. The variable is not included in the
output dataset.

The variables are not included in the output dataset.

\emph{Permitted Values}: list of variables or named expressions created by \code{exprs()}}

\item{join_type}{Observations to keep after joining

The argument determines which of the joined observations are kept with
respect to the original observation. For example, if \code{join_type = "after"}
is specified all observations after the original observations are kept.

For example for confirmed response or BOR in the oncology setting or
confirmed deterioration in questionnaires the confirmatory assessment must
be after the assessment. Thus \code{join_type = "after"} could be used.

Whereas, sometimes you might allow for confirmatory observations to occur
prior to the observation. For example, to identify AEs occurring on or
after seven days before a COVID AE. Thus \code{join_type = "all"} could be used.

\emph{Permitted Values:} \code{"before"}, \code{"after"}, \code{"all"}}

\item{first_cond_lower}{Condition for selecting range of data (before)

If this argument is specified, the other observations are restricted from
the first observation before the current observation where the specified
condition is fulfilled up to the current observation. If the condition is
not fulfilled for any of the other observations, no observations are
considered, i.e., the observation is not flagged.

This argument should be specified if \code{filter_join} contains summary
functions which should not apply to all observations but only from a
certain observation before the current observation up to the current
observation.}

\item{first_cond_upper}{Condition for selecting range of data (after)

If this argument is specified, the other observations are restricted up to
the first observation where the specified condition is fulfilled. If the
condition is not fulfilled for any of the other observations, no
observations are considered, i.e., the observation is not flagged.

This argument should be specified if \code{filter_join} contains summary
functions which should not apply to all observations but only up to the
confirmation assessment.}

\item{order}{Sort order

If the argument is set to a non-null value, for each observation of the
input dataset the first or last observation from the joined dataset is
selected with respect to the specified order. The specified variables are
expected in the additional dataset (\code{dataset_add}). If a variable is
available in both \code{dataset} and \code{dataset_add}, the one from \code{dataset_add}
is used for the sorting.

If an expression is named, e.g., \code{exprs(EXSTDT = convert_dtc_to_dt(EXSTDTC), EXSEQ)}, a corresponding variable (\code{EXSTDT}) is
added to the additional dataset and can be used in the filter conditions
(\code{filter_add}, \code{filter_join}) and for \code{join_vars} and \code{new_vars}. The
variable is not included in the output dataset.

For handling of \code{NA}s in sorting variables see \href{../articles/generic.html#sort_order}{Sort Order}.

\emph{Permitted Values}: list of expressions created by \code{exprs()}, e.g.,
\code{exprs(ADT, desc(AVAL))} or \code{NULL}}

\item{tmp_obs_nr_var}{Temporary observation number

The specified variable is added to the input dataset (\code{dataset}) and the
additional dataset (\code{dataset_add}). It is set to the observation number
with respect to \code{order}. For each by group (\code{by_vars}) the observation
number starts with \code{1}. The variable can be used in the conditions
(\code{filter_join}, \code{first_cond_upper}, \code{first_cond_lower}). It can also be
used to select consecutive observations or the last observation.}

\item{filter_add}{Filter for additional dataset (\code{dataset_add})

Only observations from \code{dataset_add} fulfilling the specified condition are
joined to the input dataset. If the argument is not specified, all
observations are joined.

Variables created by \code{order} or \code{new_vars} arguments can be used in the
condition.

The condition can include summary functions like \code{all()} or \code{any()}. The
additional dataset is grouped by the by variables (\code{by_vars}).

\emph{Permitted Values}: a condition}

\item{filter_join}{Filter for the joined dataset

The specified condition is applied to the joined dataset. Therefore
variables from both datasets \code{dataset} and \code{dataset_add} can be used.

Variables created by \code{order} or \code{new_vars} arguments can be used in the
condition.

The condition can include summary functions like \code{all()} or \code{any()}. The
joined dataset is grouped by the original observations.

\emph{Permitted Values}: a condition}

\item{check_type}{Check uniqueness?

If \code{"warning"} or \code{"error"} is specified, the specified message is issued
if the observations of the (restricted) joined dataset are not unique with
respect to the by variables and the order.

This argument is ignored if \code{order} is not specified. In this case an error
is issued independent of \code{check_type} if the restricted joined dataset
contains more than one observation for any of the observations of the input
dataset.

\emph{Permitted Values}: \code{"none"}, \code{"warning"}, \code{"error"}}
}
\description{
The helper function joins the data for the "joined" functions. All \code{.join}
variables are included in the output dataset.
}
\details{
\enumerate{
\item The variables specified by \code{order} are added to the additional dataset
(\code{dataset_add}).
\item The variables specified by \code{join_vars} are added to the additional dataset
(\code{dataset_add}).
\item The records from the additional dataset (\code{dataset_add}) are restricted to
those matching the \code{filter_add} condition.
\item The input dataset and the (restricted) additional dataset are left joined
by the grouping variables (\code{by_vars}). If no grouping variables are
specified, a full join is performed.
\item The joined dataset is restricted by the \code{filter_join} condition.
}
}
\keyword{internal}
