% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compute_qual_imputation.R
\name{compute_qual_imputation_dec}
\alias{compute_qual_imputation_dec}
\title{Compute Factor for Value Imputations When Character Value Contains < or >}
\usage{
compute_qual_imputation_dec(character_value_decimal)
}
\arguments{
\item{character_value_decimal}{Character value to determine decimal precision}
}
\value{
Decimal precision value to add or subtract
}
\description{
Function to compute factor for value imputation when character
value contains < or >.  The factor is calculated using the number of decimals.
If there are no decimals, the factor is 1, otherwise the factor = 1/10^decimal
place.  For example, the factor for 100 = 1, the factor for 5.4 = 1/10^1,
the factor for 5.44 = 1/10^2.  This results in no additional false precision
added to the value.  This is an intermediate function.
}
\details{
Derive an imputed value
}
\examples{
compute_qual_imputation_dec("<40.1")
}
\seealso{
BDS-Findings Functions that returns a vector: 
\code{\link{compute_bmi}()},
\code{\link{compute_bsa}()},
\code{\link{compute_egfr}()},
\code{\link{compute_framingham}()},
\code{\link{compute_map}()},
\code{\link{compute_qtc}()},
\code{\link{compute_qual_imputation}()},
\code{\link{compute_rr}()},
\code{\link{compute_scale}()},
\code{\link{transform_range}()}
}
\concept{com_bds_findings}
\keyword{com_bds_findings}
