% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assertions.R
\name{assert_date_var}
\alias{assert_date_var}
\title{Is a Variable in a Dataset a Date or Datetime Variable?}
\usage{
assert_date_var(dataset, var, dataset_name = NULL, var_name = NULL)
}
\arguments{
\item{dataset}{The dataset where the variable is expected}

\item{var}{The variable to check}

\item{dataset_name}{The name of the dataset. If the argument is specified, the
specified name is displayed in the error message.}

\item{var_name}{The name of the variable. If the argument is specified, the
specified name is displayed in the error message.}
}
\value{
The function throws an error if \code{var} is not a date or datetime variable in
\code{dataset} and returns the input invisibly otherwise.
}
\description{
Checks if a variable in a dataset is a date or datetime variable
}
\examples{
library(tibble)
library(lubridate)
library(rlang)

example_fun <- function(dataset, var) {
  var <- assert_symbol(enexpr(var))
  assert_date_var(dataset = dataset, var = !!var)
}

my_data <- tribble(
  ~USUBJID, ~ADT,
  "1",      ymd("2020-12-06"),
  "2",      ymd("")
)

example_fun(
  dataset = my_data,
  var = ADT
)

try(example_fun(
  dataset = my_data,
  var = USUBJID
))

example_fun2 <- function(dataset, var) {
  var <- assert_symbol(enexpr(var))
  assert_date_var(
    dataset = dataset,
    var = !!var,
    dataset_name = "your_data",
    var_name = "your_var"
  )
}

try(example_fun2(
  dataset = my_data,
  var = USUBJID
))
}
\keyword{assertion}
