% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/warnings.R
\name{warn_if_inconsistent_list}
\alias{warn_if_inconsistent_list}
\title{Warn If Two Lists are Inconsistent}
\usage{
warn_if_inconsistent_list(base, compare, list_name, i = 2)
}
\arguments{
\item{base}{A named list

\describe{
\item{Default value}{none}
}}

\item{compare}{A named list

\describe{
\item{Default value}{none}
}}

\item{list_name}{A string
the name of the list

\describe{
\item{Default value}{none}
}}

\item{i}{the index id to compare the 2 lists

\describe{
\item{Default value}{\code{2}}
}}
}
\value{
a \code{warning} if the 2 lists have different names or length
}
\description{
Checks if two list inputs have the same names and same number of elements and
issues a warning otherwise.
}
\examples{
library(dplyr, warn.conflicts = FALSE)
library(rlang)

# no warning
warn_if_inconsistent_list(
  base = exprs(DTHDOM = "DM", DTHSEQ = DMSEQ),
  compare = exprs(DTHDOM = "DM", DTHSEQ = DMSEQ),
  list_name = "Test"
)
# warning
warn_if_inconsistent_list(
  base = exprs(DTHDOM = "DM", DTHSEQ = DMSEQ, DTHVAR = "text"),
  compare = exprs(DTHDOM = "DM", DTHSEQ = DMSEQ),
  list_name = "Test"
)
}
\seealso{
Function that provide users with custom warnings
\code{\link{suppress_warning}()},
\code{\link{warn_if_incomplete_dtc}()},
\code{\link{warn_if_invalid_dtc}()},
\code{\link{warn_if_vars_exist}()}
}
\concept{warnings}
\keyword{warnings}
