% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fitting.R
\name{mynonneg}
\alias{mynonneg}
\title{Non negative least square solution.}
\usage{
mynonneg(C, d, iteration_multiplier = 3)
}
\arguments{
\item{C}{The matrix.}

\item{d}{The vector.}

\item{iteration_multiplier}{The definition of "too many steps". Default value is \eqn{3}
(times \eqn{10} times the matrix height).}
}
\value{
A vector (\code{x}) and the error (\code{resid.norm}).
}
\description{
This is the function \code{\link{lsqnonneg}} from the package \code{pracma}, 
I just changed \code{\link{qr.solve}} into using Moore-Penrose inverse instead
(\code{\link{ginv}} from \code{MASS}) as \code{\link{qr.solve}} crashes for
some singular inputs. Now it won't crash but it's sometimes running for very long
time (forever?), presumably with those problematic inputs. After too many steps
the function halts and lies that the fit was terrible. I don't think this will
cause problems.
}
\seealso{
\code{\link[pracma]{lsqnonneg}}

\code{\link{qr.solve}}

\code{\link[MASS]{ginv}}
}

