% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helper.R
\name{extract_sampler_params}
\alias{extract_sampler_params}
\title{Extract sampler parameters from a fit.}
\usage{
extract_sampler_params(fit, inc_warmup = FALSE)
}
\arguments{
\item{fit}{A list returned by \code{sample_admb} or \code{sample_tmb}.}

\item{inc_warmup}{Whether to extract the warmup samples or not
(default). Warmup samples should never be used for inference, but may
be useful for diagnostics.}
}
\value{
An invisible data.frame containing samples (rows) of each
  parameter (columns). If multiple chains exist they will be rbinded
  together.
}
\description{
Extract information about NUTS trajectories, such as acceptance ratio
and treedepth, from a fitted object.
}
\details{
Each trajectory (iteration) in NUTS has associated information
  about the trajectory: stepsize, acceptance ratio, treedepth, and number of
  leapfrog steps. This function extracts these into a data.frame, which
  may be useful for diagnosing issues in certain cases. In general, the
  user should not need to examine them, or preferably should via
  \code{\link{launch_shinytmb}} or \code{\link{launch_shinyadmb}}.
}
\examples{
fit <- readRDS(system.file('examples', 'fit_tmb.RDS', package='adnuts'))
## Examine how step size and treedepth changes as the mass matrix updates
## during warmup
sp <- extract_sampler_params(fit, inc_warmup=TRUE)
plot(0,0, type='n', xlim=c(0,510), ylim=c(0,3), xlab='Iteration',
     ylab='Step size (eps)')
for(i in 1:3) lines(1:1000, sp[sp$chain==i,4], col=i)
legend('topright', cex=.7, legend=paste("chain1", 1:3), lty=1, col=1:3)
plot(0,0, type='n', xlim=c(0,1000), ylim=c(0,10), xlab='Iteration',
     ylab='Treedepth')
for(i in 1:3) lines(1:1000, sp[sp$chain==i,5], col=i)
legend('topright', cex=.7, legend=paste("chain1", 1:3), lty=1, col=1:3)

}
\seealso{
\code{\link{launch_shinytmb}} and \code{\link{launch_shinyadmb}}.
}
