% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/project_update.R
\name{proj_update}
\alias{proj_update}
\title{Edit a project in Adobe}
\usage{
proj_update(
  projectId = NULL,
  body = NULL,
  expansion = NULL,
  locale = "en_US",
  debug = FALSE,
  company_id = Sys.getenv("AW_COMPANY_ID")
)
}
\arguments{
\item{projectId}{The project id to be edited}

\item{body}{The json string in list format which includes the edits to be made}

\item{expansion}{Comma-delimited list of additional project metadata fields to include on response. Available values : reportSuiteName, shares, tags, accessLevel, modified, externalReferences, definition}

\item{locale}{Locale Default value : en_US}

\item{debug}{Set to \code{TRUE} to publish the full JSON request(s) being sent to the API to the console when the
function is called. The default is \code{FALSE}.}

\item{company_id}{Company ID. If an environment variable called \code{AW_COMPANY_ID} exists in \code{.Renviron} or
elsewhere and no \code{company_id} argument is provided, then the \code{AW_COMPANY_ID} value will be used.
Use \code{\link[=get_me]{get_me()}} to get a list of available \code{company_id} values.}
}
\value{
A json string
}
\description{
Edits an existing project in Adobe. Note: very early in development
}
