% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DataDistribution.R, R/BinomialDistribution.R,
%   R/ChiSquaredDistribution.R, R/FDistribution.R, R/NormalDistribution.R,
%   R/StudentDistribution.R, R/Survival.R
\name{probability_density_function}
\alias{probability_density_function}
\alias{probability_density_function,Binomial,numeric,numeric,numeric-method}
\alias{probability_density_function,ChiSquared,numeric,numeric,numeric-method}
\alias{probability_density_function,NestedModels,numeric,numeric,numeric-method}
\alias{probability_density_function,Normal,numeric,numeric,numeric-method}
\alias{probability_density_function,Student,numeric,numeric,numeric-method}
\alias{probability_density_function,Survival,numeric,numeric,numeric-method}
\title{Probability density function}
\usage{
probability_density_function(dist, x, n, theta, ...)

\S4method{probability_density_function}{Binomial,numeric,numeric,numeric}(dist, x, n, theta, ...)

\S4method{probability_density_function}{ChiSquared,numeric,numeric,numeric}(dist, x, n, theta, ...)

\S4method{probability_density_function}{NestedModels,numeric,numeric,numeric}(dist, x, n, theta, ...)

\S4method{probability_density_function}{Normal,numeric,numeric,numeric}(dist, x, n, theta, ...)

\S4method{probability_density_function}{Student,numeric,numeric,numeric}(dist, x, n, theta, ...)

\S4method{probability_density_function}{Survival,numeric,numeric,numeric}(dist, x, n, theta, ...)
}
\arguments{
\item{dist}{a univariate \code{\link[=DataDistribution-class]{distribution}} object}

\item{x}{outcome}

\item{n}{sample size}

\item{theta}{distribution parameter}

\item{...}{further optional arguments}
}
\value{
value of the probability density function at point \code{x}.
}
\description{
\code{probability_density_function} evaluates the probability density
function of a specific distribution \code{dist} at a point \code{x}.
}
\details{
If the distribution is \code{\link{Binomial}},
\ifelse{html}{\out{theta}}{\eqn{theta}} denotes the rate difference between
intervention and control group.
Then, the mean is assumed to be
\ifelse{html}{\out{&radic; n  theta}}{\eqn{\sqrt{n} theta}}.

If the distribution is \code{\link{Normal}}, then
the mean is assumed to be
\ifelse{html}{\out{&radic; n  theta}}{\eqn{\sqrt{n} theta}}.
}
\examples{
probability_density_function(Binomial(.2, FALSE), 1, 50, .3)

probability_density_function(Pearson2xK(3), 1, 30, get_tau_Pearson2xK(c(0.3, 0.4, 0.7, 0.2)))
probability_density_function(ZSquared(TRUE), 1, 35, get_tau_ZSquared(0.4, 1))


probability_density_function(ANOVA(3), 1, 30, get_tau_ANOVA(c(0.3, 0.4, 0.7, 0.2)))

probability_density_function(Normal(), 1, 50, .3)

probability_density_function(Student(TRUE), 1, 40, 1.1)

probability_density_function(Survival(0.6,TRUE),0.75,50,0.9)

}
