% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/search.R
\name{search_series}
\alias{search_series}
\title{Search for specific words}
\usage{
search_series(words, case_insensitive = TRUE, require_all = FALSE)
}
\arguments{
\item{words}{A word or an array of words to check}

\item{case_insensitive}{Ignore the difference between uppercase and lowercase}

\item{require_all}{Require all words}
}
\value{
A data.frame
}
\description{
The \code{search_series()} function provides a quick way to access a list of
series that may be of interest, along with their respective IDs. Each series
appears according to the number of themes it is present in.

If one result should appear before the other, the result can be sorted by
using the word multiple times in the search, thus giving it greater
importance.
}
\examples{
\dontshow{if (aebdata:::test_connection_aeb() & requireNamespace("stringi", quietly = TRUE)) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
\donttest{
search_result <- search_series("regime de contratação")
search_result$series_title

search_result <- search_series(c("remuneração", "raça"), require_all = TRUE)
search_result$series_title
}
\dontshow{\}) # examplesIf}
}
