% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reaggregate_interval_counts.R
\name{reaggregate_interval_counts}
\alias{reaggregate_interval_counts}
\title{Reaggregate age intervals}
\usage{
reaggregate_interval_counts(
  lower_bounds,
  upper_bounds,
  counts,
  breaks,
  max_upper = 100L,
  weights = NULL
)
}
\arguments{
\item{lower_bounds, upper_bounds}{\verb{[integerish]}.

A pair of vectors representing the bounds of the intervals.

\code{lower_bounds} must be strictly less than \code{upper_bounds} and greater than or
equal to zero.

Missing (NA) bounds are not permitted.

Double vectors will be coerced to integer.}

\item{counts}{\verb{[numeric]}.

Vector of counts to be aggregated.}

\item{breaks}{\verb{[numeric]}.

1 or more cut points in increasing (strictly) order.

These correspond to the left hand side of the desired intervals (e.g. the
closed side of [x, y).

Double values are coerced to integer prior to categorisation.}

\item{max_upper}{\verb{[integerish]}

Represents the maximum upper bounds permitted upon splitting the data.

Any upper bound greater than this will be replaced with this value prior to
splitting.

Double vectors will be coerced to integer.}

\item{weights}{\verb{[numeric]}

Population weightings to apply for individual years.

If \code{NULL} (default) counts will be split evenly based on interval size.

If specified, must be of length \code{max_upper} and represent weights in the
range 0:(max_upper - 1).}
}
\value{
A data frame with 4 entries; \code{interval}, \code{lower_bound}, \code{upper_bound} and an
associated \code{count}.
}
\description{
\code{reaggregate_interval_counts()} converts counts over one interval range to
another. It first splits counts of a given age interval in to counts for
individual years based on a given weighting. These are then aggregated to the
desired breaks. Functionally this is equivalent to, but more efficient than,
a call to \code{split_interval_counts()} followed by \code{aggregate_age_counts()}.
}
\examples{

reaggregate_interval_counts(
    lower_bounds = c(0, 5, 10),
    upper_bounds = c(5, 10, 20),
    counts = c(5, 10, 30),
    breaks = c(0L, 1L, 5L, 15L, 25L, 45L, 65L)
)

}
