\name{bar.group}
\alias{bar.group}
%- bar.group.
\title{ Plotting the multiple comparison of means }
\description{
 It plots bars of the averages of treatments to compare.
 It uses the objects generated by a procedure of comparison like LSD, HSD,
 Kruskall, Waller-Duncan, Friedman or Durbin. It can also display the 'average' 
 value over each bar in a bar chart.
}
\usage{
bar.group(x, horiz = FALSE, ...)
}
\arguments{
  \item{x}{ Object created by a test of comparison }
  \item{horiz}{ Horizontal or vertical bars }
  \item{\dots}{ Parameters of the function barplot() }
}
\details{
x: data frame formed by 5 columns: name of the bars, height and level of the bar.

}
\value{

  \item{x }{Data frame}
  \item{horiz }{Logical TRUE or FALSE}
  ...
}

\author{ Felipe de Meniburu }

\seealso{\code{\link{LSD.test}}, \code{\link{HSD.test}}, \code{\link{kruskal}}, 
\code{\link{friedman}}, \code{\link{durbin.test}}, \link{waller.test} } }

\examples{
# Example 1
library(agricolae)
data(sweetpotato)
attach(sweetpotato)
model<-aov(yield~virus)
df<-df.residual(model)
MSerror<-deviance(model)/df
comparison<- LSD.test(yield, virus,df,MSerror,alpha=0.01,group=TRUE)
#startgraph
par(cex=1.5)
bar.group(comparison,horiz=TRUE,density=8,col="blue",border="red",xlim=c(0,50))
 title(cex.main=0.8,main="Comparison between\ntreatment means",xlab="Yield",
 ylab="Virus")
#endgraph
# Example 2
library(agricolae)
x <- 1:4
y <- c(0.29, 0.44, 0.09, 0.49)
xy <- data.frame(x,y,y)
#startgraph
par(cex=1.5)
bar.group(xy,density=30,angle=90,col="brown",border=FALSE,ylim=c(0,0.6),lwd=2,las=1)
#endgraph
}
\keyword{ aplot }% at least one, from doc/KEYWORDS

