\name{diffograph}
\alias{diffograph}
%- diffograph.
\title{ Plotting the multiple comparison of means }
\description{
 It plots bars of the averages of treatments to compare.  It uses the objects generated by a procedure 
 of comparison like LSD (Fisher), duncan, Tukey (HSD), Student Newman Keul (SNK), Scheffe, Ryan, Einot 
 and Gabriel and Welsch (REGW), Kruskal Wallis, Friedman and Waerden.
}
\usage{
diffograph(x, main=NULL,color1="red",color2="blue",color3="black",
cex.axis=0.8,las=1,pch=20,bty="l",cex=0.8,lwd=1,xlab="",ylab="",...)
}
\arguments{
  \item{x}{ Object created by a test of comparison, group=FALSE }
  \item{main}{ The main title (on top) }
  \item{color1}{ non significant color }
  \item{color2}{ significant color }
  \item{color3}{ center line color } 
  \item{cex.axis}{ parameters of the plot() } 
  \item{las}{ parameters of the plot() } 
  \item{pch}{ parameters of the plot() }
  \item{bty}{ parameters of the plot() } 
  \item{cex}{ parameters of the plot() } 
  \item{lwd}{ parameters of the plot() }
  \item{xlab}{ parameters of the plot() }
  \item{ylab}{ parameters of the plot() }
  \item{\dots}{ Other parameters of the function plot() }
}
\details{
The graph.diff function should be used for functions: LSD, duncan, SNK, scheffe, 
REGW, HSD, kruskal, friedman and waerden test.
}
\value{
  \item{x}{list, object comparison test}
}
\references{ Multiple comparisons theory and methods. Departament of statistics 
 the Ohio State University. USA, 1996. Jason C. Hsu. Chapman Hall/CRC }
\author{ Felipe de Mendiburu }

\seealso{
\code{\link{LSD.test}}, \code{\link{HSD.test}}, \code{\link{duncan.test}}, \code{\link{SNK.test}},
 \code{\link{scheffe.test}}, \code{\link{REGW.test}},  \code{\link{kruskal}},\code{\link{friedman}}, 
 \code{\link{waerden.test}} 
}

\examples{
# Example 1
library(agricolae)
data(sweetpotato)
model<-aov(yield~virus,data=sweetpotato)
x<- LSD.test(model,"virus",alpha=0.01,group=FALSE)
diffograph(x,cex.axis=0.8,xlab="Yield",ylab="")
# Example 2
x<- REGW.test(model,"virus",alpha=0.01,group=FALSE)
diffograph(x,cex.axis=0.6,xlab="Yield",ylab="",color1="brown",color2="green")
}
\keyword{ aplot }% at least one, from doc/KEYWORDS

