% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hello.R
\name{plot_rcdb}
\alias{plot_rcdb}
\title{Plot randomized complete block designs}
\usage{
plot_rcdb(
  design,
  y = "block",
  factor_name = "trt",
  labels = "plots",
  width = 1,
  height = 1,
  space_width = 0.95,
  space_height = 0.85,
  reverse_y = FALSE,
  reverse_x = FALSE
)
}
\arguments{
\item{design}{outdesign from \code{agricolae} package}

\item{y}{Describes the y coordinates of a experiment design}

\item{factor_name}{Which factor should be used for plotting, needs to be a column in outdesign$book}

\item{labels}{Describes the column from that the plots are taken to display them}

\item{width}{numeric value, describes the width of a plot in an experiment}

\item{height}{numeric value, describes the height of a plot in an experiment}

\item{space_width}{numeric value, describes the share of the space of the plots. 0=only space, 1=no space between plots in term of width}

\item{space_height}{numeric value, describes the share of the space of the plots. 0=only space, 1=no space between plots in term of height}

\item{reverse_y}{boolean, should the plots of the experiment be changed in reverse order in Row direction? use reverse_y=TRUE to have same sketch as in agricolae. default:reverse_y=FALSE}

\item{reverse_x}{boolean, should the plots of the experiment be changed in reverse order in column direction? default:reverse_x=FALSE}
}
\value{
\code{ggplot} graphic that can be modified, if wished
}
\description{
Plot a design of an experiment with randomized complete block design (rcbd) design from \code{agricolae} design.rcbd
}
\examples{
library(agricolaeplotr)
library(agricolae)
# 5 treatments and 6 blocks
trt<-c('A','B','C','D','E')
outdesign <-design.rcbd(trt,6,serie=2,986,'Wichmann-Hill') # seed = 986
plot_rcdb(outdesign)
plot_rcdb(outdesign,reverse_y = TRUE,reverse_x = TRUE)

}
