% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_S3_methods.R
\name{print.smaAgri}
\alias{print.smaAgri}
\title{Print an object of class \code{smaAgri}}
\usage{
\method{print}{smaAgri}(x, ...)
}
\arguments{
\item{x}{An object fitted with the function \code{single_trial_analysis()}.}

\item{...}{Options used by the tibble package to format the output. See
`tibble::print()` for more details.}
}
\value{
an object inheriting from class \code{smaAgri}.
}
\description{
Prints information about \code{single_trial_analysis} function.
}
\examples{
\donttest{
library(agridat)
library(agriutilities)
data(besag.met)
dat <- besag.met
results <- check_design_met(
  data = dat,
  genotype = "gen",
  trial = "county",
  traits = c("yield"),
  rep = "rep",
  block = "block",
  col = "col",
  row = "row"
)
out <- single_trial_analysis(results, progress = FALSE)
print(out)
}
}
\author{
Johan Aparicio [aut]
}
