% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sampleFeatureAllocation.R
\name{sampleFeatureAllocation}
\alias{sampleFeatureAllocation}
\title{Sample from a Feature Allocation Distribution}
\usage{
sampleFeatureAllocation(
  nSamples,
  distribution,
  implementation = "scala",
  parallel = TRUE
)
}
\arguments{
\item{nSamples}{An integer giving the number of samples}

\item{distribution}{A feature allocation distribution object as defined in the functions
\code{\link{aibd}} or \code{\link{ibp}}.}

\item{implementation}{The default of "scala" should be used.  The "R" option is not
a supported implementation.}

\item{parallel}{Whether multiple cores should be used to generate the samples.}
}
\value{
A list of feature allocation matrices sampled from the supplied distribution.
}
\description{
This function obtains a sample from a previously defined feature allocation
distribution object using wither the \code{\link{ibp}} or the \code{\link{aibd}}
functions.
}
\examples{
\donttest{ # Regardless of size, the initial warmup can exceed CRAN's 5 seconds threshold
d1 <- ibp(1,4)

states <- c("California","Wisconsin","Nebraska","New York")
data <- USArrests[states,]
dist <- dist(scale(data))
d2 <- aibd(1, seq_along(states), 1.0, dist)

samples_ibp <- sampleFeatureAllocation(10, d1, parallel=FALSE)
samples_aibd <- sampleFeatureAllocation(15, d2, parallel=FALSE)
}

}
