% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aux_fct.R
\name{create_synthetic_units}
\alias{create_synthetic_units}
\title{Create synthetic units}
\usage{
create_synthetic_units(embedding, target, k, max_k, method, cat, cat_freq)
}
\arguments{
\item{embedding}{Named \code{data.frame} containing the text embeddings.
In most cases this object is taken from \link{EmbeddedText}$embeddings.}

\item{target}{Named \code{factor} containing the labels/categories of the corresponding cases.}

\item{k}{\code{int} The number of nearest neighbors during sampling process.}

\item{max_k}{\code{int} The maximum number of nearest neighbors during sampling process.}

\item{method}{\code{vector} containing strings of the requested methods for generating new cases.
Currently "smote","dbsmote", and "adas" from the package smotefamily are available.}

\item{cat}{\code{string} The category for which new cases should be created.}

\item{cat_freq}{Object of class \code{"table"} containing the absolute frequencies
of every category/label.}
}
\value{
Returns a \code{list} which contains the text embeddings of the
new synthetic cases as a named \code{data.frame} and their labels as a named
\code{factor}.
}
\description{
Function for creating synthetic cases in order to balance the data for
training with \link{TextEmbeddingClassifierNeuralNet}. This is an auxiliary
function for use with \link{get_synthetic_cases} to allow parallel
computations.
}
\seealso{
Other Auxiliary Functions: 
\code{\link{array_to_matrix}()},
\code{\link{calc_standard_classification_measures}()},
\code{\link{check_embedding_models}()},
\code{\link{create_iota2_mean_object}()},
\code{\link{generate_id}()},
\code{\link{get_coder_metrics}()},
\code{\link{get_folds}()},
\code{\link{get_n_chunks}()},
\code{\link{get_stratified_train_test_split}()},
\code{\link{get_synthetic_cases}()},
\code{\link{get_train_test_split}()},
\code{\link{matrix_to_array_c}()},
\code{\link{split_labeled_unlabeled}()},
\code{\link{summarize_tracked_sustainability}()},
\code{\link{to_categorical_c}()}
}
\concept{Auxiliary Functions}
