% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/frequentist.R
\name{APCEsummaryipw}
\alias{APCEsummaryipw}
\title{Summary of APCE for frequentist analysis}
\usage{
APCEsummaryipw(
  G1_est,
  G2_est,
  G3_est,
  G4_est,
  G5_est,
  G1_boot,
  G2_boot,
  G3_boot,
  G4_boot,
  G5_boot,
  name.group = c("Overall", "Female", "Male", "Non-white\\nMale", "White\\nMale")
)
}
\arguments{
\item{G1_est}{List generated from \code{CalAPCEipw} for the first subgroup.}

\item{G2_est}{List generated from \code{CalAPCEipw} for the second subgroup.}

\item{G3_est}{List generated from \code{CalAPCEipw} for the third subgroup.}

\item{G4_est}{List generated from \code{CalAPCEipw} for the fourth subgroup.}

\item{G5_est}{List generated from \code{CalAPCEipw} for the fifth subgroup.}

\item{G1_boot}{List generated from \code{BootstrapAPCEipw} for the first subgroup.}

\item{G2_boot}{List generated from \code{BootstrapAPCEipw} for the second subgroup.}

\item{G3_boot}{List generated from \code{BootstrapAPCEipw} for the third subgroup.}

\item{G4_boot}{List generated from \code{BootstrapAPCEipw} for the fourth subgroup.}

\item{G5_boot}{List generated from \code{BootstrapAPCEipw} for the fifth subgroup.}

\item{name.group}{A list of character vectors for the label of five subgroups.}
}
\value{
A \code{data.frame} that consists of mean and quantiles (2.5%, 97.5%, 5%, 95%) of APCE (P(D(1)=d| R=r)-P(D(0)=d| R=r)) for each subgroup given specific value of D (decision) and R (principal strata).
}
\description{
Summary of average principal causal effects (APCE) with ordinal decision with frequentist results.
}
\examples{
data(synth)
synth$SexWhite = synth$Sex * synth$White
freq_apce = CalAPCEipw(synth)
boot_apce = BootstrapAPCEipw(synth, rep = 10)
# subgroup analysis
data_s0 = subset(synth, synth$Sex==0,select=-c(Sex,SexWhite))
freq_s0 = CalAPCEipw(data_s0)
boot_s0 = BootstrapAPCEipw(data_s0, rep = 10)
data_s1 = subset(synth, synth$Sex==1,select=-c(Sex,SexWhite))
freq_s1 = CalAPCEipw(data_s1)
boot_s1 = BootstrapAPCEipw(data_s1, rep = 10)
data_s1w0 = subset(synth, synth$Sex==1&synth$White==0,select=-c(Sex,White,SexWhite))
freq_s1w0 = CalAPCEipw(data_s1w0)
boot_s1w0 = BootstrapAPCEipw(data_s1w0, rep = 10)
data_s1w1 = subset(synth, synth$Sex==1&synth$White==1,select=-c(Sex,White,SexWhite))
freq_s1w1 = CalAPCEipw(data_s1w1)
boot_s1w1 = BootstrapAPCEipw(data_s1w1, rep = 10)

freq_apce_summary <- APCEsummaryipw(freq_apce, freq_s0, freq_s1, freq_s1w0, freq_s1w1,
                                    boot_apce, boot_s0, boot_s1, boot_s1w0, boot_s1w0)
PlotAPCE(freq_apce_summary, y.max = 0.25, decision.labels = c("signature","small cash",
         "middle cash","large cash"), shape.values = c(16, 17, 15, 18), 
         col.values = c("blue", "black", "red", "brown", "purple"), label = FALSE)

}
