% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllClasses.R
\docType{class}
\name{TimeScale-class}
\alias{TimeScale-class}
\alias{.TimeScale}
\title{TimeScale}
\description{
A virtual S4 class to represent a calendar.
}
\section{Slots}{

\describe{
\item{\code{label}}{A \code{\link{character}} string specifying the abbreviated label of
the time scale.}

\item{\code{name}}{A \code{\link{character}} string specifying the name of the time scale.}

\item{\code{epoch}}{A \code{\link{numeric}} value specifying the epoch year from which
years are counted (starting date of the calendar, in years). Allows to
define multiple era of a calendar.}

\item{\code{fixed}}{A \code{\link{numeric}} value specifying the reference date of the calendar
(in \emph{rata die}).}

\item{\code{direction}}{An \code{\link{integer}} specifying if years are counted backwards
(\code{-1}) or forwards (\code{1}) from \code{epoch}.}

\item{\code{year}}{A \code{\link{numeric}} value giving the average length of the year in
solar days.}
}}

\seealso{
Other classes: 
\code{\link{AD-class}},
\code{\link{BC-class}},
\code{\link{BCE-class}},
\code{\link{BP-class}},
\code{\link{CE-class}},
\code{\link{GregorianCalendar-class}},
\code{\link{JulianCalendar-class}},
\code{\link{RataDie-class}},
\code{\link{TimeSeries-class}},
\code{\link{b2k-class}}

Other calendar classes: 
\code{\link{GregorianCalendar-class}},
\code{\link{JulianCalendar-class}}
}
\author{
N. Frerebeau
}
\concept{calendar classes}
\concept{classes}
