% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/calendar.R
\docType{methods}
\name{calendar}
\alias{calendar}
\alias{calendar-method}
\alias{calendar,character-method}
\title{Calendar}
\usage{
calendar(object)

\S4method{calendar}{character}(object)
}
\arguments{
\item{object}{A \code{\link{character}} string specifying the abbreviated label of
the time scale (see details) or an object from which to extract the time
scale.}
}
\value{
A \code{\linkS4class{TimeScale}} object.
}
\description{
Calendar
}
\details{
The following time scales are available:

\tabular{lll}{
\strong{label}   \tab \strong{era}            \tab \strong{calendar} \cr
\code{BP}        \tab Before Present     \tab Gregorian    \cr
\code{BC}        \tab Before Christ      \tab Gregorian    \cr
\code{BCE}       \tab Before Common Era  \tab Gregorian    \cr
\code{AD}        \tab Anno Domini        \tab Gregorian    \cr
\code{CE}        \tab Common Era         \tab Gregorian    \cr
\code{b2k}       \tab Years before 2000  \tab Gregorian    \cr
\code{julian}    \tab                    \tab Julian       \cr
}
}
\note{
Inspired by \code{\link[era:era]{era::era()}} by Joe Roe.
}
\examples{
## Define time scales
calendar("BP")
calendar("AD")
calendar("julian")

## Shortcuts
BP()
AD()
J()
}
\seealso{
Other calendar tools: 
\code{\link{calendar_get}},
\code{\link{convert}()},
\code{\link{gregorian}},
\code{\link{is}()},
\code{\link{julian}()}
}
\author{
N. Frerebeau
}
\concept{calendar tools}
