% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/span.R
\docType{methods}
\name{span}
\alias{span}
\alias{span-method}
\alias{span,TimeSeries-method}
\alias{span,TimeIntervals-method}
\title{Duration}
\usage{
span(x, ...)

\S4method{span}{TimeSeries}(x, calendar = NULL)

\S4method{span}{TimeIntervals}(x, calendar = NULL)
}
\arguments{
\item{x}{A \code{\linkS4class{TimeSeries}} or a \code{\linkS4class{TimeIntervals}} object.}

\item{...}{Currently not used.}

\item{calendar}{A \code{\linkS4class{TimeScale}} object specifying the target calendar
(see \code{\link[=calendar]{calendar()}}). If \code{NULL} (the default), \emph{rata die} are returned.}
}
\value{
A \code{\link{numeric}} vector of years.
}
\description{
Get the duration of time series or intervals.
}
\examples{
## Create time intervals
int <- intervals(
  start = c(625, 700, 1200, 1225, 1250, 500, 1000, 1200,
            1325, 1375, 1200, 1300, 1375, 1275, 1325),
  end = c(750, 825, 1250, 1275, 1325, 700, 1300, 1325,
          1400, 1500, 1300, 1375, 1500, 1325, 1425),
  calendar = CE()
)

## Get time durations
span(int, calendar = CE())
}
\seealso{
Other tools: 
\code{\link{overlap}()},
\code{\link{start}()},
\code{\link{time}()},
\code{\link{window}()}
}
\author{
N. Frerebeau
}
\concept{tools}
