% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/airport_lookups.R
\name{airport_lookup}
\alias{airport_lookup}
\title{Translate airport codes or names into other standard airport formats}
\usage{
airport_lookup(input, input_type = "IATA", output_type = "name")
}
\arguments{
\item{input}{An airport name, IATA code, or ICAO code. Input type will be guessed unless #' explicitly defined}

\item{input_type}{One of "name", "IATA", or "ICAO". Function will attempt to guess type
if not supplied}

\item{output_type}{One of "name", "city", "IATA", or "ICAO". Defaults to "name" if
otherwise not specified}
}
\value{
The appropriate city, airport name, IATA code, or ICAO code for that airport
}
\description{
Return city name, airport name, IATA code, or IACO code given an input IATA code, ICAO code, or airport name.
}
\examples{
airport_lookup("CYVR")
airport_lookup("YVR", output_type = "city")
airport_lookup("Vancouver International Airport", input_type="name",output_type = "IATA")
airport_lookup("YVR",input_type = "IATA", output_type = "city")

# Produces a list of similar named airports
airport_lookup("Vancoover","name","city")
}
