% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/algo_effectiveness_poly.R
\name{effectiveness_poly}
\alias{effectiveness_poly}
\title{Computes the actual and predicted effectiveness of the collection of algorithms.}
\usage{
effectiveness_poly(mod)
}
\arguments{
\item{mod}{A fitted \code{mirt} model using the function \code{irtmodel} or \code{R} package \code{mirt}.}
}
\value{
A list with the following components:
\item{\code{effectivenessAUC}}{The area under the actual and predicted effectiveness curves. }
\item{\code{actcurves}}{The \code{x,y} coodinates for the actual  effectiveness curves for each algorithm. }
#' \item{\code{prdcurves}}{The \code{x,y} coodinates for the predicted  effectiveness curves for each algorithm. }
}
\description{
This function computes the actual and predicted effectiveness of the collection of algorithms for different tolerance values.
}
\examples{
set.seed(1)
x1 <- sample(1:5, 100, replace = TRUE)
x2 <- sample(1:5, 100, replace = TRUE)
x3 <- sample(1:5, 100, replace = TRUE)
X <- cbind.data.frame(x1, x2, x3)
mod <- pirtmodel(X)
out <- effectiveness_poly(mod$model)
out
}
