% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{kappa4IntApprox}
\alias{kappa4IntApprox}
\alias{kappa4IntApprox2}
\title{Sample arc length statistic.}
\usage{
kappa4IntApprox(x, y, q1, q2, quantile)

kappa4IntApprox2(x, y, q1, q2, quantile)
}
\arguments{
\item{x}{Numeric vector of independent outcomes.}

\item{y}{Numeric vector of dependent outcomes \eqn{y=F(x)}.}

\item{q1, q2}{Quantiles (between 0 and 1) over which the arc length segment is to be computed.}

\item{quantile}{Logical, TRUE/FALSE, whether \code{q1} and \code{q2} are quantiles, or actual points in the domain.}
}
\value{
kappa4IntApprox: The resultant arc length.

kappa4IntApprox2: A vector having length equal to that of the vector of lower quantile bounds, containing the discrete arc length segments over the specified intervals.
}
\description{
The arc length over a specified interval is calculated for use in non-linear estimation.
}
\examples{
x <- rnorm(100)
y <- pnorm(x)
kappa4IntApprox(x, y, 0.025, 0.975, TRUE)
kappa4IntApprox(x, y, -1.96, 1.96, FALSE)

kappa4IntApprox2(x, y, c(0.025, 0.5), c(0.5, 0.975), TRUE)
kappa4IntApprox2(x, y, c(-1.96, 0), c(0, 1.96), FALSE)

}
