% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/isovist.R
\name{isovist2pts}
\alias{isovist2pts}
\title{Create isovists using two points}
\usage{
isovist2pts(boundaryMap, x, y, toX, toY, viewAngle, verbose = FALSE)
}
\arguments{
\item{boundaryMap}{A ShapeMap with lines designating the isovist boundaries}

\item{x}{X coordinate of the origin points}

\item{y}{Y coordinate of the origin points}

\item{toX}{X coordinate of the target points}

\item{toY}{Y coordinate of the target points}

\item{viewAngle}{The angle signifying the isovist's field of view}

\item{verbose}{Optional. Show more information of the process.}
}
\value{
A ShapeMap with the isovist polygons
}
\description{
Create one or more isovists at particular points, given another point for
direction and an angle for field of view
}
\examples{
mifFile <- system.file(
    "extdata", "testdata", "simple",
    "simple_interior.mif",
    package = "alcyon"
  )
  sfMap <- st_read(mifFile,
    geometry_column = 1L, quiet = TRUE
  )
  shapeMap <- as(sfMap[, vector()], "ShapeMap")
isovist2pts(
  shapeMap,
  x = c(3.01, 1.3),
  y = c(6.70, 5.2),
  toX = c(3.40, 1.1),
  toY = c(6.50, 5.6),
  viewAngle = 3.14,
  FALSE
)
}
