% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AxialShapeGraph.R
\docType{methods}
\name{links,AxialShapeGraph-method}
\alias{links,AxialShapeGraph-method}
\title{Get the Axial ShapeGraph links}
\usage{
\S4method{links}{AxialShapeGraph}(map)
}
\arguments{
\item{map}{An Axial ShapeGraph}
}
\value{
A matrix with the linked refs
}
\description{
Get the Axial ShapeGraph links
}
\examples{
# links of an axial map
mifFile <- system.file(
    "extdata", "testdata", "barnsbury",
    "barnsbury_small_axial_original.mif",
    package = "alcyon"
  )
  sfMap <- st_read(mifFile,
    geometry_column = 1L, quiet = TRUE
  )
  shapeGraph <- as(sfMap, "AxialShapeGraph")
linkRefs(shapeGraph, 0L, 9L)
unlinkCoords(shapeGraph, 530923.0, 184041.0, 530956.0, 183887.0)
links(shapeGraph)
}
