% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/peaks.R
\docType{methods}
\name{peaks_find}
\alias{peaks_find}
\alias{peaks_find-method}
\alias{peaks_find,numeric,numeric-method}
\alias{peaks_find,ANY,missing-method}
\title{Find Peaks}
\usage{
peaks_find(x, y, ...)

\S4method{peaks_find}{numeric,numeric}(x, y, method = "MAD", SNR = 2, m = NULL, ...)

\S4method{peaks_find}{ANY,missing}(x, method = "MAD", SNR = 2, m = NULL, ...)
}
\arguments{
\item{x, y}{A \code{\link{numeric}} vector. If \code{y} is missing, an attempt is made to
interpret \code{x} in a suitable way (see \code{\link[grDevices:xy.coords]{grDevices::xy.coords()}}).}

\item{...}{Extra parameters to be passed to internal methods.}

\item{method}{A \code{\link{character}} string specifying the method to be used for
background noise estimation (see below).}

\item{SNR}{An \code{\link{integer}} giving the signal-to-noise-ratio for peak detection
(see below).}

\item{m}{An odd \code{\link{integer}} giving the window size (i.e. the number of
adjacent points to be used).
If \code{NULL}, 5\% of the data points is used as the half window size.}
}
\value{
Returns a \code{\link{list}} with two components \code{x} and \code{y}.
}
\description{
Finds local maxima in sequential data.
}
\details{
A local maximum has to be the highest one in the given window and has to be
higher than \eqn{SNR \times noise}{SNR * noise} to be recognized as peak.

The following methods are available for noise estimation:
\describe{
\item{\code{MAD}}{Median Absolute Deviation.}
}

Note that to improve peak detection, it may be helpful to smooth the data
and remove the baseline beforehand.
}
\note{
There will be \eqn{(m - 1) / 2} points both at the beginning and at the end
of the data series for which a complete \eqn{m}-width window cannot be
obtained. To prevent data loss, progressively wider/narrower windows are
used at both ends of the data series.

Adapted from Stasia Grinberg's
\href{https://github.com/stas-g/findPeaks}{\code{findPeaks}} function.
}
\examples{
## X-ray diffraction
data("XRD")

## 4S Peak Filling baseline
baseline <- baseline_peakfilling(XRD, n = 10, m = 5, by = 10, sparse = TRUE)

plot(XRD, type = "l", xlab = expression(2*theta), ylab = "Count")
lines(baseline, type = "l", col = "red")

## Correct baseline
XRD <- signal_drift(XRD, lag = baseline, subtract = TRUE)

## Find peaks
peaks <- peaks_find(XRD, SNR = 3, m = 11)

plot(XRD, type = "l", xlab = expression(2*theta), ylab = "Count")
lines(peaks, type = "p", pch = 16, col = "red")
abline(h = attr(peaks, "noise"), lty = 2) # noise threshold

## Half-Width at Half-Maximum
x <- seq(-4, 4, length = 1000)
y <- dnorm(x)

peaks_fwhm(x, y, center = 0) # Expected: 2 * sqrt(2 * log(2))
}
\seealso{
Other peaks detection methods: 
\code{\link{peaks_fwhm}()}
}
\author{
N. Frerebeau
}
\concept{peaks detection methods}
