% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/smooth.R
\docType{methods}
\name{smooth_savitzky}
\alias{smooth_savitzky}
\alias{smooth_savitzky-method}
\alias{smooth_savitzky,numeric,numeric-method}
\alias{smooth_savitzky,ANY,missing-method}
\title{Savitzky-Golay Filter}
\usage{
smooth_savitzky(x, y, ...)

\S4method{smooth_savitzky}{numeric,numeric}(x, y, m = 3, p = 2)

\S4method{smooth_savitzky}{ANY,missing}(x, m, p)
}
\arguments{
\item{x, y}{A \code{\link{numeric}} vector. If \code{y} is missing, an attempt is made to
interpret \code{x} in a suitable way (see \code{\link[grDevices:xy.coords]{grDevices::xy.coords()}}).}

\item{...}{Currently not used.}

\item{m}{An odd \code{\link{integer}} giving the window size (i.e. the number of
adjacent points to be used).}

\item{p}{An \code{\link{integer}} giving the degree of the polynomial to be used.}
}
\value{
Returns a \code{\link{list}} with two components \code{x} and \code{y}.
}
\description{
Savitzky-Golay Filter
}
\details{
This method is based on the least-squares fitting of polynomials to
segments of \eqn{m} adjacent points.
}
\note{
There will be \eqn{(m - 1) / 2} points both at the beginning and at the end
of the data series for which a complete \eqn{m}-width window cannot be
obtained. To prevent data loss, the original \eqn{(m - 1) / 2} points at
both ends of the data series are preserved.
}
\examples{
## Simulate data with some noise
x <- seq(-4, 4, length = 100)
y <- dnorm(x) + rnorm(100, mean = 0, sd = 0.01)

## Plot spectrum
plot(x, y, type = "l", xlab = "", ylab = "")

## Rectangular smoothing
unweighted <- smooth_rectangular(x, y, m = 3)
plot(unweighted, type = "l", xlab = "", ylab = "")

## Triangular smoothing
weighted <- smooth_triangular(x, y, m = 5)
plot(weighted, type = "l", xlab = "", ylab = "")

## Loess smoothing
loess <- smooth_loess(x, y, span = 0.75)
plot(loess, type = "l", xlab = "", ylab = "")

## Savitzky–Golay filter
savitzky <- smooth_savitzky(x, y, m = 21, p = 2)
plot(savitzky, type = "l", xlab = "", ylab = "")

## Whittaker smoothing
whittaker <- smooth_whittaker(x, y, lambda = 1600, d = 2)
plot(whittaker, type = "l", xlab = "", ylab = "")
}
\references{
Gorry, P. A. (1990). General Least-Squares Smoothing and Differentiation by
the Convolution (Savitzky-Golay) Method. \emph{Analytical Chemistry}, 62(6),
p. 570-573. \doi{10.1021/ac00205a007}.

Savitzky, A. & Golay, M. J. E. (1964). Smoothing and Differentiation of
Data by Simplified Least Squares Procedures. \emph{Analytical Chemistry},
36(8), p. 1627-1639. \doi{10.1021/ac60214a047}.
}
\seealso{
Other smoothing methods: 
\code{\link{smooth_likelihood}()},
\code{\link{smooth_loess}()},
\code{\link{smooth_rectangular}()},
\code{\link{smooth_triangular}()},
\code{\link{smooth_whittaker}()}
}
\author{
N. Frerebeau
}
\concept{smoothing methods}
