% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api.R
\name{app_jobs}
\alias{app_jobs}
\alias{get_app_jobs}
\alias{get_job}
\title{Get App Jobs}
\usage{
get_app_jobs(app, request_params = list(), gallery = get_gallery())

get_job(job, gallery = get_gallery())
}
\arguments{
\item{app}{A single \code{alteryx_app} returned from \code{get_app}}

\item{request_params}{List of app search parameters. For more information on
parameters, visit the Alteryx Gallery API documentation
\url{https://gallery.alteryx.com/api-docs/} and see the parameters under the
'Find workflows in a subscription' section.}

\item{gallery}{URL for your Alteryx Gallery}

\item{job}{An Alteryx job returned from \code{get_app_jobs} or
\code{queue_jobs}}
}
\description{
A job is a single run of an app. To queue a job for an app use
\code{queue_app}. Once queued, there are two ways to poll the gallery
for an update on the job status: \code{get_app_jobs} or \code{get_job}.

\code{get_app_jobs} will return all jobs for a given app.
\code{get_job} will return a single job and is mostly used for polling the
status of a job.
}
\section{See Also}{

Once a job is complete, use \code{get_job_output} to retrieve
the results.
}

\examples{
\dontrun{
# get the five most recently queued jobs for an app
request_params <- list(
  sortField = "createdate",
  limit = "5"
)

get_app_jobs(app, request_params)

# queue a job and poll the job's status until it is "Completed"
job <- queue_job(app, answers)

while(job$status != "Completed") {
job <- get_job(job)
Sys.sleep(2)
}
}

}
