% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/process.R
\name{process_terraclimate}
\alias{process_terraclimate}
\title{Process TerraClimate data}
\usage{
process_terraclimate(
  date = c("2023-09-01", "2023-09-10"),
  variable = NULL,
  path = NULL,
  extent = NULL,
  ...
)
}
\arguments{
\item{date}{character(1 or 2). Date (1) or start and end dates (2).
Format YYYY-MM-DD (ex. September 1, 2023 = "2023-09-01").}

\item{variable}{character(1). Variable name or acronym code. See \href{https://climate.northwestknowledge.net/TERRACLIMATE/index_directDownloads.php}{TerraClimate Direct Downloads}
for variable names and acronym codes.}

\item{path}{character(1). Directory with downloaded netCDF (.nc) files.}

\item{extent}{numeric(4) or SpatExtent giving the extent of the raster
if \code{NULL} (default), the entire raster is loaded}

\item{...}{Placeholders.}
}
\value{
a \code{SpatRaster} object
}
\description{
The \code{process_terraclimate()} function imports and cleans climate and water balance
data, returning a single \code{SpatRaster} object.
}
\note{
Layer names of the returned \code{SpatRaster} object contain the variable acronym, year,
and month.

TerraClimate data has monthly temporal resolution, so the first day of each month
is used as a placeholder temporal value.
}
\examples{
## NOTE: Example is wrapped in `\dontrun{}` as function requires a large
##       amount of data which is not included in the package.
\dontrun{
terraclimate <- process_terraclimate(
  date = c("2023-01-01", "2023-01-10"),
  variable = "Precipitation",
  path = "./data/ppt"
)
}
}
\author{
Mitchell Manware
}
