% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ambiorix.R
\name{Ambiorix}
\alias{Ambiorix}
\title{Ambiorix}
\value{
An object of class \code{Ambiorix} from which one can
add routes, routers, and run the application.
}
\description{
Web server.
}
\examples{
app <- Ambiorix$new()

app$get("/", function(req, res){
 res$send("Using {ambiorix}!")
})

app$on_stop <- function(){
 cat("Bye!\n")
}

if(interactive())
 app$start()


## ------------------------------------------------
## Method `Ambiorix$listen`
## ------------------------------------------------

app <- Ambiorix$new()

app$listen(3000L)

app$get("/", function(req, res){
 res$send("Using {ambiorix}!")
})

if(interactive())
 app$start()

## ------------------------------------------------
## Method `Ambiorix$set_404`
## ------------------------------------------------

app <- Ambiorix$new()

app$set_404(function(req, res){
 res$send("Nothing found here")
})

app$get("/", function(req, res){
 res$send("Using {ambiorix}!")
})

if(interactive())
 app$start()

## ------------------------------------------------
## Method `Ambiorix$set_error`
## ------------------------------------------------

# my custom error handler:
error_handler <- function(req, res, error) {
  if (!is.null(error)) {
    error_msg <- conditionMessage(error)
    cli::cli_alert_danger("Error: {error_msg}")
  }
  response <- list(
    code = 500L,
    msg = "Uhhmmm... Looks like there's an error from our side :("
  )
  res$
    set_status(500L)$
    json(response)
}

# handler for GET at /whoami:
whoami <- function(req, res) {
  # simulate error (object 'Pikachu' is not defined)
  print(Pikachu)
}

app <- Ambiorix$
  new()$
  set_error(error_handler)$
  get("/whoami", whoami)

if (interactive()) {
  app$start(open = FALSE)
}

## ------------------------------------------------
## Method `Ambiorix$start`
## ------------------------------------------------

app <- Ambiorix$new()

app$get("/", function(req, res){
 res$send("Using {ambiorix}!")
})

if(interactive())
 app$start(port = 3000L)

## ------------------------------------------------
## Method `Ambiorix$serialiser`
## ------------------------------------------------

app <- Ambiorix$new()

app$serialiser(function(data, ...){
 jsonlite::toJSON(x, ..., pretty = TRUE)
})

app$get("/", function(req, res){
 res$send("Using {ambiorix}!")
})

if(interactive())
 app$start()
}
\section{Super class}{
\code{\link[ambiorix:Routing]{ambiorix::Routing}} -> \code{Ambiorix}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{not_found}}{404 Response, must be a handler function that accepts the request and the response, by default uses \code{\link[=response_404]{response_404()}}.}

\item{\code{error}}{500 response when the route errors, must a handler function that accepts the request and the response, by default uses \code{\link[=response_500]{response_500()}}.}

\item{\code{on_stop}}{Callback function to run when the app stops, takes no argument.}
}
\if{html}{\out{</div>}}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{port}}{Port to run the application.}

\item{\code{host}}{Host to run the application.}

\item{\code{limit}}{Max body size, defaults to \code{5 * 1024 * 1024}.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-Ambiorix-new}{\code{Ambiorix$new()}}
\item \href{#method-Ambiorix-cache_templates}{\code{Ambiorix$cache_templates()}}
\item \href{#method-Ambiorix-listen}{\code{Ambiorix$listen()}}
\item \href{#method-Ambiorix-set_404}{\code{Ambiorix$set_404()}}
\item \href{#method-Ambiorix-set_error}{\code{Ambiorix$set_error()}}
\item \href{#method-Ambiorix-static}{\code{Ambiorix$static()}}
\item \href{#method-Ambiorix-start}{\code{Ambiorix$start()}}
\item \href{#method-Ambiorix-serialiser}{\code{Ambiorix$serialiser()}}
\item \href{#method-Ambiorix-stop}{\code{Ambiorix$stop()}}
\item \href{#method-Ambiorix-print}{\code{Ambiorix$print()}}
\item \href{#method-Ambiorix-clone}{\code{Ambiorix$clone()}}
}
}
\if{html}{\out{
<details><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="ambiorix" data-topic="Routing" data-id="all"><a href='../../ambiorix/html/Routing.html#method-Routing-all'><code>ambiorix::Routing$all()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ambiorix" data-topic="Routing" data-id="delete"><a href='../../ambiorix/html/Routing.html#method-Routing-delete'><code>ambiorix::Routing$delete()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ambiorix" data-topic="Routing" data-id="engine"><a href='../../ambiorix/html/Routing.html#method-Routing-engine'><code>ambiorix::Routing$engine()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ambiorix" data-topic="Routing" data-id="get"><a href='../../ambiorix/html/Routing.html#method-Routing-get'><code>ambiorix::Routing$get()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ambiorix" data-topic="Routing" data-id="get_middleware"><a href='../../ambiorix/html/Routing.html#method-Routing-get_middleware'><code>ambiorix::Routing$get_middleware()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ambiorix" data-topic="Routing" data-id="get_receivers"><a href='../../ambiorix/html/Routing.html#method-Routing-get_receivers'><code>ambiorix::Routing$get_receivers()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ambiorix" data-topic="Routing" data-id="get_routes"><a href='../../ambiorix/html/Routing.html#method-Routing-get_routes'><code>ambiorix::Routing$get_routes()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ambiorix" data-topic="Routing" data-id="options"><a href='../../ambiorix/html/Routing.html#method-Routing-options'><code>ambiorix::Routing$options()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ambiorix" data-topic="Routing" data-id="patch"><a href='../../ambiorix/html/Routing.html#method-Routing-patch'><code>ambiorix::Routing$patch()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ambiorix" data-topic="Routing" data-id="post"><a href='../../ambiorix/html/Routing.html#method-Routing-post'><code>ambiorix::Routing$post()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ambiorix" data-topic="Routing" data-id="prepare"><a href='../../ambiorix/html/Routing.html#method-Routing-prepare'><code>ambiorix::Routing$prepare()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ambiorix" data-topic="Routing" data-id="put"><a href='../../ambiorix/html/Routing.html#method-Routing-put'><code>ambiorix::Routing$put()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ambiorix" data-topic="Routing" data-id="receive"><a href='../../ambiorix/html/Routing.html#method-Routing-receive'><code>ambiorix::Routing$receive()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ambiorix" data-topic="Routing" data-id="use"><a href='../../ambiorix/html/Routing.html#method-Routing-use'><code>ambiorix::Routing$use()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Ambiorix-new"></a>}}
\if{latex}{\out{\hypertarget{method-Ambiorix-new}{}}}
\subsection{Method \code{new()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Ambiorix$new(
  host = getOption("ambiorix.host", "0.0.0.0"),
  port = getOption("ambiorix.port", NULL),
  log = getOption("ambiorix.logger", TRUE)
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{host}}{A string defining the host.}

\item{\code{port}}{Integer defining the port, defaults to \code{ambiorix.port} option: uses a random port if \code{NULL}.}

\item{\code{log}}{Whether to generate a log of events.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Define the webserver.
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Ambiorix-cache_templates"></a>}}
\if{latex}{\out{\hypertarget{method-Ambiorix-cache_templates}{}}}
\subsection{Method \code{cache_templates()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Ambiorix$cache_templates()}\if{html}{\out{</div>}}
}

\subsection{Details}{
Cache templates in memory instead of reading
them from disk.
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Ambiorix-listen"></a>}}
\if{latex}{\out{\hypertarget{method-Ambiorix-listen}{}}}
\subsection{Method \code{listen()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Ambiorix$listen(port)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{port}}{Port number.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Specifies the port to listen on.
}

\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{app <- Ambiorix$new()

app$listen(3000L)

app$get("/", function(req, res){
 res$send("Using {ambiorix}!")
})

if(interactive())
 app$start()
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Ambiorix-set_404"></a>}}
\if{latex}{\out{\hypertarget{method-Ambiorix-set_404}{}}}
\subsection{Method \code{set_404()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Ambiorix$set_404(handler)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{handler}}{Function that accepts the request and returns an object
describing an httpuv response, e.g.: \code{\link[=response]{response()}}.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Sets the 404 page.
}

\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{app <- Ambiorix$new()

app$set_404(function(req, res){
 res$send("Nothing found here")
})

app$get("/", function(req, res){
 res$send("Using {ambiorix}!")
})

if(interactive())
 app$start()
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Ambiorix-set_error"></a>}}
\if{latex}{\out{\hypertarget{method-Ambiorix-set_error}{}}}
\subsection{Method \code{set_error()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Ambiorix$set_error(handler)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{handler}}{Function that accepts a request, response and an error object.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Sets the error handler.
}

\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{# my custom error handler:
error_handler <- function(req, res, error) {
  if (!is.null(error)) {
    error_msg <- conditionMessage(error)
    cli::cli_alert_danger("Error: {error_msg}")
  }
  response <- list(
    code = 500L,
    msg = "Uhhmmm... Looks like there's an error from our side :("
  )
  res$
    set_status(500L)$
    json(response)
}

# handler for GET at /whoami:
whoami <- function(req, res) {
  # simulate error (object 'Pikachu' is not defined)
  print(Pikachu)
}

app <- Ambiorix$
  new()$
  set_error(error_handler)$
  get("/whoami", whoami)

if (interactive()) {
  app$start(open = FALSE)
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Ambiorix-static"></a>}}
\if{latex}{\out{\hypertarget{method-Ambiorix-static}{}}}
\subsection{Method \code{static()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Ambiorix$static(path, uri = "www")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{path}}{Local path to directory of assets.}

\item{\code{uri}}{URL path where the directory will be available.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Static directories
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Ambiorix-start"></a>}}
\if{latex}{\out{\hypertarget{method-Ambiorix-start}{}}}
\subsection{Method \code{start()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Ambiorix$start(port = NULL, host = NULL, open = interactive())}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{port}}{Integer defining the port, defaults to \code{ambiorix.port} option: uses a random port if \code{NULL}.}

\item{\code{host}}{A string defining the host.}

\item{\code{open}}{Whether to open the app the browser.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Start
Start the webserver.
}

\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{app <- Ambiorix$new()

app$get("/", function(req, res){
 res$send("Using {ambiorix}!")
})

if(interactive())
 app$start(port = 3000L)
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Ambiorix-serialiser"></a>}}
\if{latex}{\out{\hypertarget{method-Ambiorix-serialiser}{}}}
\subsection{Method \code{serialiser()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Ambiorix$serialiser(handler)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{handler}}{Function to use to serialise.
This function should accept two arguments: the object to serialise and \code{...}.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Define Serialiser
}

\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{app <- Ambiorix$new()

app$serialiser(function(data, ...){
 jsonlite::toJSON(x, ..., pretty = TRUE)
})

app$get("/", function(req, res){
 res$send("Using {ambiorix}!")
})

if(interactive())
 app$start()
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Ambiorix-stop"></a>}}
\if{latex}{\out{\hypertarget{method-Ambiorix-stop}{}}}
\subsection{Method \code{stop()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Ambiorix$stop()}\if{html}{\out{</div>}}
}

\subsection{Details}{
Stop
Stop the webserver.
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Ambiorix-print"></a>}}
\if{latex}{\out{\hypertarget{method-Ambiorix-print}{}}}
\subsection{Method \code{print()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Ambiorix$print()}\if{html}{\out{</div>}}
}

\subsection{Details}{
Print
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Ambiorix-clone"></a>}}
\if{latex}{\out{\hypertarget{method-Ambiorix-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Ambiorix$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
