% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/rUV_sym_fc.R
\name{rUV_sym_fc}
\alias{rUV_sym_fc}
\title{Gibbs sampling of U and V}
\usage{
rUV_sym_fc(E, U, V, s2 = 1, shrink=TRUE)
}
\arguments{
\item{E}{square residual relational matrix}

\item{U}{current value of U}

\item{V}{current value of V}

\item{s2}{dyadic variance}

\item{shrink}{adaptively shrink the factors with a hierarchical prior}
}
\value{
\item{U}{a new value of U} \item{V}{a new value of V}
}
\description{
A Gibbs sampler for updating the multiplicative effect matrices U and V
in the symmetric case. In this case \code{U\%*\%t(V)} is symmetric, so
this is parameterized as \code{V=U\%*\%L} where \code{L} is the
diagonal matrix of eigenvalues of \code{U\%*\%t(V)}.
}
\examples{
U0<-matrix(rnorm(30,2),30,2) ; V0<-U0\%*\%diag(c(3,-2))
E<- U0\%*\%t(V0) + matrix(rnorm(30^2),30,30)
rUV_sym_fc
}
\author{
Peter Hoff
}

