% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ASI.AMMI.R
\name{ASI.AMMI}
\alias{ASI.AMMI}
\title{AMMI Stability Index}
\usage{
ASI.AMMI(model, ssi.method = c("farshadfar", "rao"), a = 1)
}
\arguments{
\item{model}{The AMMI model (An object of class \code{AMMI} generated by
\code{\link[agricolae]{AMMI}}).}

\item{ssi.method}{The method for the computation of simultaneous selection
index. Either \code{"farshadfar"} or \code{"rao"} (See
\code{\link[ammistability]{SSI}}).}

\item{a}{The ratio of the weights given to the stability components for
computation of SSI when \code{method = "rao"} (See
\code{\link[ammistability]{SSI}}).}
}
\value{
A data frame with the following columns:  \item{ASI}{The ASI values.}
  \item{SSI}{The computed values of simultaneous selection index for yield
  and stability.} \item{rASI}{The ranks of ASI values.} \item{rY}{The ranks
  of the mean yield of genotypes.} \item{means}{The mean yield of the
  genotypes.}

  The names of the genotypes are indicated as the row names of the data
  frame.
}
\description{
\code{ASI.AMMI} computes the AMMI Stability Index (ASI) (Jambhulkar et al.,
2014; Jambhulkar et al., 2015; Jambhulkar et al., 2017) considering the first
two interaction principal components (IPCs) in the AMMI model. Using ASI, the
Simultaneous Selection Index for Yield and Stability (SSI) is also calculated
according to the argument \code{ssi.method}.
}
\details{
The AMMI Stability Index (\ifelse{html}{\out{<i>ASI</i>}}{\eqn{ASI}}) is
computed as follows:

\ifelse{html}{\out{<p style="text-align: center;"><i>ASI =
<big>&radic;[</big>[PC<sup>2</sup><sub style="line-height: 1.8; margin-left:
-1ex;">1</sub> &times; &theta;<sup>2</sup><sub style="line-height: 1.8;
margin-left: -1ex;">1</sub>] + [PC<sup>2</sup><sub style="line-height: 1.8;
margin-left: -1ex;">2</sub> &times; &theta;<sup>2</sup><sub
style="line-height: 1.8; margin-left:
-1ex;">2</sub>]<big>]</big></i></p>}}{\deqn{ASI = \sqrt{\left [ PC_{1}^{2}
\times \theta_{1}^{2} \right ]+\left [ PC_{2}^{2} \times \theta_{2}^{2}
\right ]}}}

Where, \ifelse{html}{\out{<i>PC<sub>1</sub></i>}}{\eqn{PC_{1}}} and
\ifelse{html}{\out{<i>PC<sub>2</sub></i>}}{\eqn{PC_{2}}} are the scores of
1st and 2nd IPCs respectively; and
\ifelse{html}{\out{<i>&theta;<sub>1</sub></i>}}{\eqn{\theta_{1}}} and
\ifelse{html}{\out{<i>&theta;<sub>2</sub></i>}}{\eqn{\theta_{2}}} are
percentage sum of squares explained by the 1st and 2nd principal component
interaction effect respectively.
}
\examples{
library(agricolae)
data(plrv)

# AMMI model
model <- with(plrv, AMMI(Locality, Genotype, Rep, Yield, console = FALSE))

# ANOVA
model$ANOVA

# IPC F test
model$analysis

# Mean yield and IPC scores
model$biplot

# G*E matrix (deviations from mean)
array(model$genXenv, dim(model$genXenv), dimnames(model$genXenv))

# With default ssi.method (farshadfar)
ASI.AMMI(model)

# With  ssi.method = "rao"
ASI.AMMI(model, ssi.method = "rao")

# Changing the ratio of weights for Rao's SSI
ASI.AMMI(model, ssi.method = "rao", a = 0.43)

}
\references{
\insertRef{jambhulkar_ammi_2014}{ammistability}

\insertRef{jambhulkar_genotype_2015}{ammistability}

\insertRef{jambhulkar_stability_2017}{ammistability}
}
\seealso{
\code{\link[agricolae]{AMMI}}, \code{\link[ammistability]{SSI}}
}
