% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ammistability.R
\name{ammistability}
\alias{ammistability}
\title{Estimate multiple AMMI model Stability Parameters}
\usage{
ammistability(model, n, alpha = 0.05, ssi.method = c("farshadfar",
  "rao"), a = 1, AMGE = TRUE, ASI = TRUE, ASV = TRUE,
  ASTAB = TRUE, AVAMGE = TRUE, DA = TRUE, DZ = TRUE, EV = TRUE,
  FA = TRUE, MASI = TRUE, MASV = TRUE, SIPC = TRUE, ZA = TRUE,
  force.grouping = TRUE, line.size = 1, line.alpha = 0.5,
  line.col = NULL, point.size = 1, point.alpha = 0.5,
  point.col = NULL, text.size = 2)
}
\arguments{
\item{model}{The AMMI model (An object of class \code{AMMI} generated by
\code{\link[agricolae]{AMMI}}).}

\item{n}{The number of principal components to be considered for computation.
The default value is the number of significant IPCs.}

\item{alpha}{Type I error probability (Significance level) to be considered
to identify the number of significant IPCs.}

\item{ssi.method}{The method for the computation of simultaneous selection
index. Either \code{"farshadfar"} or \code{"rao"} (See
\code{\link[ammistability]{SSI}}).}

\item{a}{The ratio of the weights given to the stability components for
computation of SSI when \code{method = "rao"} (See
\code{\link[ammistability]{SSI}}).}

\item{AMGE}{If \code{TRUE}, computes AMGE (see \strong{Details}). Default is
\code{TRUE}.}

\item{ASI}{If \code{TRUE}, computes ASI (see \strong{Details}). \code{n = 2}
will be used in this case. Default is \code{TRUE}.}

\item{ASV}{If \code{TRUE}, computes ASV (see \strong{Details}). \code{n = 2}
will be used in this case. Default is \code{TRUE}.}

\item{ASTAB}{If \code{TRUE}, computes ASTAB (see \strong{Details}). Default
is \code{TRUE}.}

\item{AVAMGE}{If \code{TRUE}, computes AVAMGE (see \strong{Details}). Default
is \code{TRUE}.}

\item{DA}{If \code{TRUE}, computes DA (see \strong{Details}). Default is
\code{TRUE}.}

\item{DZ}{If \code{TRUE}, computes DZ (see \strong{Details}). Default is
\code{TRUE}.}

\item{EV}{If \code{TRUE}, computes EV (see \strong{Details}). Default is
\code{TRUE}.}

\item{FA}{If \code{TRUE}, computes FA (see \strong{Details}). Default is
\code{TRUE}.}

\item{MASI}{If \code{TRUE}, computes MASI (see \strong{Details}). Default is
\code{TRUE}.}

\item{MASV}{If \code{TRUE}, computes MASV (see \strong{Details}). Default is
\code{TRUE}.}

\item{SIPC}{If \code{TRUE}, computes SIPC (see \strong{Details}). Default is
\code{TRUE}.}

\item{ZA}{If \code{TRUE}, computes ZA (see \strong{Details}). Default is
\code{TRUE}.}

\item{force.grouping}{If \code{TRUE}, genotypes will be considered as a
grouping variable for plotting the slopegraphs. (Each genotype will be
represented by a different colour in the slopegraphs). Default is
\code{TRUE}.}

\item{line.size}{Size of lines plotted in the slopegraphs. Must be numeric.}

\item{line.alpha}{Transparency of lines plotted in the slopegraphs. Must be
numeric.}

\item{line.col}{Default is \code{TRUE}. Overrides colouring by
\code{force.grouping} argument.}

\item{point.size}{Size of points plotted in the slopegraphs. Must be numeric.}

\item{point.alpha}{Transparency of points plotted in the slopegraphs. Must be
numeric.}

\item{point.col}{Default is \code{TRUE}. Overrides colouring by
\code{force.grouping} argument.}

\item{text.size}{Size of text annotations plotted in the slopegraphs. Must be
numeric.}
}
\value{
A list with the following components: \item{Details}{A data frame
  indicating the stability parameters computed and the method used for
  computing the SSI.} \item{Stability Parameters}{A data frame of computed
  stability parameters.} \item{Simultaneous Selection Indices}{A data frame
  of computed SSIs.} \item{SP Correlation}{A data frame of correlation
  between stability parameters.} \item{SSI Correlation}{A data frame of
  correlation between SSIs.} \item{SP and SSI Correlation}{A data frame of
  correlation between stability parameters and SSIs.} \item{SP
  Correlogram}{Correlogram of stability parameters.} \item{SSI
  Correlogram}{Correlogram of SSIs.} \item{SP and SSI
  Correlogram}{Correlogram of stability parameters and SSIs.} \item{SP
  Slopegraph}{Slopegraph of stability parameter ranks.} \item{SSI
  Slopegraph}{Slopegraph of SSI ranks.} \item{SP
  Heatmap}{Heatmap of stability parameter ranks.} \item{SSI
  Heatmap}{Heatmap of SSI ranks.}
}
\description{
\code{ammistability} computes multiple stability parameters from an AMMI
model. Further, the corresponding Simultaneous Selection Indices for Yield
and Stability (SSI) are also calculated according to the argument
\code{ssi.method}. From the results, correlation between the computed indices
will also be computed. The resulting correlation matrices will be plotted as
correlograms. For visual comparisons of ranks of genotypes for different
indices, slopegraphs and heatmaps will also be generated by this function.
}
\details{
\code{ammistability} computes the following stability parameters from an AMMI
model.

\describe{ \item{\link[ammistability:AMGE.AMMI]{Sum Across Environments of
GEI Modelled by AMMI (AMGE)}}{Sneller et al., 1997}
\item{\link[ammistability:ASI.AMMI]{AMMI Stability Index (ASI)}}{Jambhulkar
et al., 2014; Jambhulkar et al., 2015; Jambhulkar et al., 2017}
\item{\link[ammistability:MASV.AMMI]{AMMI Stability Value (ASV)}}{Purchase
1997; Purchase et al., 1999; Purchase et al., 2000}
\item{\link[ammistability:ASTAB.AMMI]{AMMI Based Stability Parameter
(ASTAB)}}{Rao and Prabhakaran, 2005}
\item{\link[ammistability:AVAMGE.AMMI]{Sum Across Environments of Absolute
Value of GEI Modelled by AMMI (AVAMGE)}}{Zali et al., 2012}
\item{\link[ammistability:DA.AMMI]{Annicchiarico's D Parameter
(DA)}}{Annicchiarico, 1997} \item{\link[ammistability:DZ.AMMI]{Zhang's D
Parameter (DZ)}}{Zhang, 1998} \item{\link[ammistability:EV.AMMI]{Averages of
the Squared Eigenvector Values (EV)}}{Zobel, 1994}
\item{\link[ammistability:FA.AMMI]{Stability Measure Based on Fitted AMMI
Model (FA)}}{Raju, 2002} \item{\link[ammistability:MASI.AMMI]{Modified AMMI
Stability Index (MASI)}}{Ajay et al., 2018}
\item{\link[ammistability:MASV.AMMI]{Modified AMMI Stability Value
(MASV)}}{Zali et al., 2012} \item{\link[ammistability:SIPC.AMMI]{Sums of the
Absolute Value of the IPC Scores (SIPC)}}{Sneller et al., 1997}
\item{\link[ammistability:ZA.AMMI]{Absolute Value of the Relative
Contribution of IPCs to the Interaction (Za)}}{Zali et al., 2012} }
}
\examples{
library(agricolae)
data(plrv)

# AMMI model
model <- with(plrv, AMMI(Locality, Genotype, Rep, Yield, console = FALSE))

ammistability(model, AMGE = TRUE, ASI = FALSE, ASV = TRUE, ASTAB = FALSE,
              AVAMGE = FALSE, DA = FALSE, DZ = FALSE, EV = TRUE,
              FA = FALSE, MASI = FALSE, MASV = TRUE, SIPC = TRUE,
              ZA = FALSE)
}
\references{
\insertRef{zobel_stress_1994}{ammistability}

\insertRef{annicchiarico_joint_1997}{ammistability}

\insertRef{purchase_parametric_1997}{ammistability}

\insertRef{sneller_repeatability_1997}{ammistability}

\insertRef{zhang_analysis_1998}{ammistability}

\insertRef{purchase_use_1999}{ammistability}

\insertRef{purchase_genotype_2000}{ammistability}

\insertRef{raju_study_2002}{ammistability}

\insertRef{rao_use_2005}{ammistability}

\insertRef{zali_evaluation_2012}{ammistability}

\insertRef{jambhulkar_ammi_2014}{ammistability}

\insertRef{jambhulkar_genotype_2015}{ammistability}

\insertRef{jambhulkar_stability_2017}{ammistability}
}
\seealso{
\code{\link[agricolae]{AMMI}},
  \code{\link[ammistability]{AMGE.AMMI}},
  \code{\link[ammistability]{ASI.AMMI}},
  \code{\link[ammistability]{ASTAB.AMMI}},
  \code{\link[ammistability]{AMGE.AMMI}},
  \code{\link[ammistability]{DA.AMMI}}, \code{\link[ammistability]{DZ.AMMI}},
  \code{\link[ammistability]{EV.AMMI}}, \code{\link[ammistability]{FA.AMMI}},
  \code{\link[ammistability]{MASV.AMMI}},
  \code{\link[ammistability]{SIPC.AMMI}},
  \code{\link[ammistability]{ZA.AMMI}}, \code{\link[ammistability]{SSI}}
}
