% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hr_isopleths.R
\name{hr_isopleths}
\alias{hr_isopleths}
\alias{hr_isopleths.RasterLayer}
\alias{hr_isopleths.mcp}
\alias{hr_isopleths.locoh}
\alias{hr_isopleths.hr_prob}
\alias{hr_isopleths.akde}
\title{Home-range isopleths}
\usage{
hr_isopleths(x, ...)

\method{hr_isopleths}{RasterLayer}(x, level, descending = TRUE, ...)

\method{hr_isopleths}{mcp}(x, descending = TRUE, ...)

\method{hr_isopleths}{locoh}(x, descending = TRUE, ...)

\method{hr_isopleths}{hr_prob}(x, descending = TRUE, ...)

\method{hr_isopleths}{akde}(x, conf.level = 0.95, descending = TRUE, ...)
}
\arguments{
\item{x}{An object of class \code{hr}}

\item{...}{Further arguments, none implemented.}

\item{level}{\verb{[numeric]} \cr The isopleth levels used for calculating home
ranges. Should be \verb{0 < level < 1}.}

\item{descending}{\verb{[logical = TRUE]} \cr Indicating if levels (and thus the polygons) should be ordered in descending (default) or not.}

\item{conf.level}{The confidence level for isopleths for \code{aKDE}.}
}
\value{
A \code{tibble} with the home-range level and a simple feature columns with the isoploth as multipolygon.
}
\description{
Obtain the isopleths of a home-range estimate, possible at different isopleth levels.
}
