% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate.R
\name{redistribution_kernel}
\alias{redistribution_kernel}
\title{Create a redistribution kernel}
\usage{
redistribution_kernel(
  x = make_issf_model(),
  start = make_start(),
  map,
  fun = function(xy, map) {
     extract_covariates(xy, map, where = "both")
 },
  covars = NULL,
  max.dist = get_max_dist(x),
  n.control = 1e+06,
  n.sample = 1,
  stochastic = FALSE,
  compensate.movement = !stochastic,
  normalize = TRUE,
  interpolate = FALSE,
  as.rast = FALSE,
  tolerance.outside = 0
)
}
\arguments{
\item{x}{\verb{[fit_issf]} \cr A fitted integrated step-selection function. Generated either with \code{fit_issf()} or make \code{make_issf_model()}.}

\item{start}{\verb{[sim_start]} \cr The start position in space and time. See \code{make_start()}.}

\item{map}{\verb{[SpatRaster]} \cr A SpatRaster with all covariates.}

\item{fun}{\verb{[function]} \cr A function that is executed on each location of the redistribution kernel. The default function is \code{extract_covariates()}.}

\item{covars}{\verb{[tibble]} \cr Additional covariates that might be used in the model (e.g., time of day).}

\item{max.dist}{\verb{[numeric(1)]} \cr The maximum distance of the redistribution kernel.}

\item{n.control}{\verb{[integer(1)]\{1e6\}} \cr The number of points of the redistribution kernel (this is only important if \code{stochastic = TRUE}).}

\item{n.sample}{\verb{[integer(1)]\{1\}} \cr The number of points sampled from the redistribution kernel (this is only important if \code{as.rast = FALSE}).}

\item{stochastic}{\verb{[logical(1)]\{FALSE\}} \cr If \code{TRUE} the redistribution kernel is sampled using a random sample of size \code{n.control}. Otherwise each cell in the redistribution kernel is used.}

\item{compensate.movement}{\verb{[logical(1)]} \cr Indicates if movement parameters are corrected or not. This only relevant if \code{stochastic = FALSE}.}

\item{normalize}{\verb{[logical(1)]\{TRUE\}} \cr If \code{TRUE} the redistribution kernel is normalized to sum to one.}

\item{interpolate}{\verb{[logical(1)]\{FALSE\}} \cr If \code{TRUE} a stochastic redistribution kernel is interpolated to return a raster layer. Note, this is just for completeness and is computationally inefficient in most situations.}

\item{as.rast}{\verb{[logical(1)]\{TRUE\}} \cr If \code{TRUE} a \code{SpatRaster} should be returned.}

\item{tolerance.outside}{\verb{[numeric(1)]\{0\}} \cr The proportion of the redistribution kernel that is allowed to be outside the \code{map}.}
}
\description{
From a fitted integrated step-selection function for a given position a
redistribution kernel is calculated (i.e., the product of the movement kernel
and the selection function).
}
