% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/droplet-ssh.R
\name{droplet_ssh}
\alias{droplet_ssh}
\alias{droplet_upload}
\alias{droplet_download}
\title{Remotely execute ssh code, upload & download files.}
\usage{
droplet_ssh(droplet, ..., user = "root", verbose = FALSE)

droplet_upload(droplet, local, remote, user = "root", verbose = FALSE)

droplet_download(droplet, remote, local, user = "root", verbose = FALSE,
  overwrite = FALSE)
}
\arguments{
\item{droplet}{A droplet, or something that can be coerced to a droplet by
\code{\link{as.droplet}}.}

\item{...}{Shell commands to run. Multiple commands are combined with
\code{&&} so that execution will halt after the first failure.}

\item{user}{User name. Defaults to "root".}

\item{verbose}{If TRUE, will print command before executing it.}

\item{local, remote}{Local and remote paths.}

\item{overwrite}{If TRUE, then overwrite destination files if they already
exist.}
}
\value{
On success, the droplet (invisibly). On failure, throws an error.
}
\description{
Assumes that you have ssh & scp installed, and password-less login set up on
the droplet.
}
\details{
Uploads and downloads are recursive, so if you specify a directory,
everything inside the directory will also be downloaded.
}
\examples{
\dontrun{
d <- droplet_create() \%>\% droplet_wait()

# Upgrade system packages
d \%>\%
  droplet_ssh("apt-get update") \%>\%
  droplet_ssh("sudo apt-get upgrade -y --force-yes") \%>\%
  droplet_ssh("apt-get autoremove -y")

# Install R
d \%>\%
  droplet_ssh("apt-get install r-base-core r-base-dev --yes --force-yes")

# Upload and download files -------------------------------------------------

tmp <- tempfile()
saveRDS(mtcars, tmp)
d \%>\% droplet_upload(tmp, "mtcars.rds")

tmp2 <- tempfile()
d \%>\% droplet_download("mtcars.rds", tmp2)
mtcars2 <- readRDS(tmp2)

stopifnot(all.equal(mtcars, mtcars2))
}
}
