% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/domains.R
\name{domain_create}
\alias{domain_create}
\alias{domain_delete}
\title{Create/delete domains.}
\usage{
domain_create(name, ip_address, ...)

domain_delete(domain, ...)
}
\arguments{
\item{name}{(character) Required. The domain name to add to the
DigitalOcean DNS management interface. The name must be unique in
DigitalOcean's DNS system. The request will fail if the name has already
been taken.}

\item{ip_address}{(character) Required. An IP address for the domain's
initial A record.}

\item{...}{Further args passed on the curl call to the web.}

\item{domain}{A domain to modify}
}
\description{
Create/delete domains.
}
\examples{
\dontrun{
d <- domain_create('tablesandchairsbunnies.info', '107.170.220.59')
domain_delete(d)
}
}
