% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/r-helper-utilites-python.R
\name{getTargetForPyClassification}
\alias{getTargetForPyClassification}
\title{Extracts selected column from a data frame a binary class Python array}
\usage{
getTargetForPyClassification(dataset, targetVarName, positiveClass)
}
\arguments{
\item{dataset}{an R data frame}

\item{targetVarName}{Name of the target variable for classification. Should be a categorical variable.}

\item{positiveClass}{Name of the class of the target variable which should be coded as '1'}
}
\description{
Extracts selected column from a data frame a binary class Python array
}
\details{
Helper function, which when provided an R dataframe and a binary categorical column,
extracts it from the R data frame, converts it to 1/0 class coding, and converts it to a Python array

Typically this function can be used to extract a target variable for a classifier to be provided to a
Python machine learning function
}
\examples{
\dontrun{
getTargetForPyClassification(dataset = iris,
 targetVarName = "Species", positiveClass = "setosa")
}
}
\seealso{
Other R helper utilities for Python: \code{\link{getFeaturesForPyClassification}},
  \code{\link{setPythonEnvir}}
}
\concept{R helper utilities for Python}
