% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/anim.plots.R
\name{anim.curve}
\alias{anim.curve}
\title{Draw an animated curve.}
\usage{
anim.curve(expr, x = NULL, from = 0, to = 1, n = 255, times,
  type = "l", ...)
}
\arguments{
\item{expr}{a function which takes two arguments, or an expression involving
\code{x} and \code{t}.}

\item{x}{values of \code{x} at which the function will be evaluated in each frame.
Alternatively, you may specify \code{from, to} and \code{n}.}

\item{from, to}{endpoints of \code{x}}

\item{n}{number of values of \code{x} at which the function will be evaluated
for each frame}

\item{times}{vector of values of \code{t} at which the function will be 
evaluated. Each unique value creates a single animation frame.}

\item{type, ...}{parameters passed to \code{\link{anim.plot.default}}}
}
\description{
This function is the animated version of \code{\link{curve}}.
}
\details{
Note that \code{times} is interpreted differently here than elsewhere. In
particular, it cannot be a length-1 vector.
}
\examples{
anim.curve(x^t, times=10:50/10, n=20)
anim.curve(sin(x*t), times=1:30, n=100, speed=12, col="darkgreen", from=-1, to=1)

## curve is constant in t, but window moves. 
## NB: 'from' and 'to' control where the expression is evaluated. 
## 'xlim' just controls the window.
anim.curve(sin(cos(-x)*exp(x/2)), times=0:100/10, from=-5, to=10, n=500, 
     col="red", lwd=2, xlim=rbind(top <- seq(-5, 10, 1/10), top+5))
}
