% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extractBoxes.R
\name{extractBoxesFromFlat}
\alias{extractBoxesFromFlat}
\title{Extract crops from a single image represented by a processed dataframe}
\usage{
extractBoxesFromFlat(
  image,
  min_conf = 0,
  buffer = 0,
  plot = TRUE,
  save = FALSE,
  resize = NA,
  outdir = "",
  quality = 0.8
)
}
\arguments{
\item{image}{dataframe containing MD output (assumes single row)}

\item{min_conf}{Confidence threshold (defaults to 0, not in use)}

\item{buffer}{Adds a buffer to the MD bounding box, defaults to 2px}

\item{plot}{Toggle to plot each crop in the plot window, defaults to TRUE}

\item{save}{Toggle to save output cropped, defaults to FALSE}

\item{resize}{Size in pixels to resize cropped images, NA if images are not resized, defaults to NA}

\item{outdir}{Directory in which output cropped images will be saved}

\item{quality}{Compression level of output cropped image, defaults to 0.8}
}
\value{
A dataframe containing image and crop paths
}
\description{
Extract crops from a single image represented by a processed dataframe
}
\examples{
\dontrun{
crops <- extractBoxesFromFlat(mdresflat[1,],save=TRUE,out)
}
}
