% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/moving_ac_corrected.R
\name{moving_ac_corrected}
\alias{moving_ac_corrected}
\title{Transforms the data X to account for autocorrelation using a moving window and a burn-in.}
\usage{
moving_ac_corrected(X, burnin, window_size)
}
\arguments{
\item{X}{A numeric matrix containing the potentially multivariate data to be transformed. Each column corresponds to a component and each row to an observation.
The time series data classes ts, xts, and zoo are also supported.}

\item{burnin}{A positive integer indicating the initial length of the data used to determine the value of \eqn{\phi_{i}}.}

\item{window_size}{A positive integer indication the length of the moving window.}
}
\value{
A numeric matrix of the same dimension as X containing the transformed data.
}
\description{
Transforms the data X by centring and scaling using \eqn{X_{ij}^{'} = \frac{X_{ij}-\mu_{ij}}{k_{i} \sigma_{ij}}} where \eqn{\mu_{ij}} and \eqn{\sigma_{ij}} are 
robust estimates for location and scale based on the median and the median absolute deviation of each variate (column) \eqn{X_{i}} of X calculated on a moving window centred at j.  
The scaling \eqn{k_{i} = \surd{\left( \frac{1+\phi_{i}}{1-\phi_{i}} \right)}} is a robust estimate for the autocorrelation at lag 1 calculated on an initial (burn-in) segment
of the data where \eqn{\phi_{i}} is calculated using a robust estimate for the autocorrelation of the burn-in segment.
}
