% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tabulated_state_vector.R
\name{tabulate_state_vector}
\alias{tabulate_state_vector}
\title{Tabulate State Vector}
\usage{
tabulate_state_vector(data, block_length, level_limit = 50, level_keep = 10)
}
\arguments{
\item{data}{data}

\item{block_length}{integer value to divide data by}

\item{level_limit}{integer value to determine the cutoff for the number of
factors in a column to display before being reduced to show the number of
levels to keep (default is 50)}

\item{level_keep}{integer value indicating the top number of factor levels to
retain if a column has more than the level limit (default is 10)}
}
\value{
A data frame where each row represents one block and the columns count
  the number of occurrences that character/factor level occurred in that block
}
\description{
\code{tabulate_state_vector} employs a tabulated vector approach to transform
security log data into unique counts of data attributes based on time blocks.
Taking a contingency table approach, this function separates variables of type
character or factor into their unique levels and counts the number of occurrences
for those levels within each block. Due to the large number of unique IP address,
this function allows for the user to determine how many IP addresses they would
like to investigate (takes the top occurrences for IP variables).
}
\examples{
tabulate_state_vector(security_logs, 30)

}
