% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot.anscombe}
\alias{plot.anscombe}
\title{Plot method for objects of class "anscombe"}
\usage{
\method{plot}{anscombe}(x, input = FALSE, stats = TRUE, digits = 3, legend_args = list(), ...)
}
\arguments{
\item{x}{an object of class \code{'anscombe'}, a result of a call to
\code{\link{anscombise}} or \code{\link{mimic}}.}

\item{input}{A logical scalar.  Should the old, input data, that is, the
Anscombe's dataset chosen for \code{\link{anscombise}} or the argument \code{x2} to
\code{\link{mimic}}, be plotted?  If \code{old = FALSE} then the new, output data are
plotted. If \code{old = TRUE} then the old data are plotted.}

\item{stats}{A logical scalar.  Should the sample summary statistics
\code{n}, \code{means}, \code{variances} and \code{correlation} be added to the plot?}

\item{digits}{An integer.  The argument \code{digits} passed to \code{\link{signif}}
to round the values of the statistics before adding them to the plot.}

\item{legend_args}{A list of arguments to be passed to
\code{\link[graphics:legend]{legend}} when \code{stats = TRUE}, especially
\code{legend_args$x} to control the position of the legend.}

\item{...}{Further arguments to be passed to \code{\link[graphics:plot.default]{plot}}}
}
\value{
Nothing is returned.
}
\description{
\code{plot} method for objects inheriting from class \code{"anscombe"}.
}
\details{
This function is only applicable in 2 dimensions, that is,
when \code{length(attr(x, "new_stats")$means)} = 2.
}
\section{Examples}{

See the examples in \code{\link{anscombise}} and \code{\link{mimic}}.
}

\seealso{
\code{\link{anscombise}} and \code{\link{mimic}}.
}
