% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/editCluster.R
\name{editCluster}
\alias{editCluster}
\title{Edit an existing cluster}
\usage{
editCluster(area, cluster_name, ..., time_series = NULL,
  prepro_data = NULL, prepro_modulation = NULL, add_prefix = TRUE,
  opts = antaresRead::simOptions())
}
\arguments{
\item{area}{The area where to create the cluster.}

\item{cluster_name}{cluster name.}

\item{...}{Parameters to write in the Ini file.}

\item{time_series}{the "ready-made" 8760-hour time-series available for simulation purposes.}

\item{prepro_data}{Pre-process data, a \code{data.frame} or \code{matrix}, 
default is a matrix with 365 rows and 6 columns.}

\item{prepro_modulation}{Pre-process modulation, a \code{data.frame} or \code{matrix}, 
if specified, must have 8760 rows and 1 or 4 columns.}

\item{add_prefix}{If \code{TRUE}, cluster_name will be prefixed by area name.}

\item{opts}{List of simulation parameters returned by the function
\code{antaresRead::setSimulationPath}}
}
\value{
An updated list containing various information about the simulation.
}
\description{
Edit an existing cluster
}
\examples{
\dontrun{

# Update only nominalCapacity for an existing cluster
editCluster(area = "myarea", cluster_name = "mycluster", nominalcapacity = 10600.000)

}
}
