% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/h5_writeH5ByYear.R
\name{writeAntaresH5}
\alias{writeAntaresH5}
\title{Convert antares output to h5 file}
\usage{
writeAntaresH5(
  path = NULL,
  timeSteps = c("hourly", "daily", "weekly", "monthly", "annual"),
  opts = simOptions(),
  writeMcAll = TRUE,
  compress = 1,
  misc = FALSE,
  thermalAvailabilities = FALSE,
  hydroStorage = FALSE,
  hydroStorageMaxPower = FALSE,
  reserve = FALSE,
  linkCapacity = FALSE,
  mustRun = FALSE,
  thermalModulation = FALSE,
  allData = FALSE,
  writeAllSimulations = FALSE,
  nbCores = 4,
  removeVirtualAreas = FALSE,
  storageFlexibility = NULL,
  production = NULL,
  reassignCosts = FALSE,
  newCols = TRUE,
  overwrite = FALSE,
  supressMessages = FALSE
)
}
\arguments{
\item{path}{\code{character} folder where h5 file will be write (default NULL)}

\item{timeSteps}{\code{character} timeSteps}

\item{opts}{\code{list} of simulation parameters returned by the function \link{setSimulationPath}. Default to \code{antaresRead::simOptions()}}

\item{writeMcAll}{\code{boolean} write mc-all}

\item{compress}{\code{numeric} compress level}

\item{misc}{\code{boolean} see \link[antaresRead]{readAntares}}

\item{thermalAvailabilities}{\code{boolean} see \link[antaresRead]{readAntares}}

\item{hydroStorage}{\code{boolean} see \link[antaresRead]{readAntares}}

\item{hydroStorageMaxPower}{\code{boolean} see \link[antaresRead]{readAntares}}

\item{reserve}{\code{boolean} see \link[antaresRead]{readAntares}}

\item{linkCapacity}{\code{boolean} see \link[antaresRead]{readAntares}}

\item{mustRun}{\code{boolean} see \link[antaresRead]{readAntares}}

\item{thermalModulation}{\code{boolean} see \link[antaresRead]{readAntares}}

\item{allData}{\code{boolean} add all data with a single call (writeMcAll, misc, thermalAvailabilities, hydroStorage, hydroStorageMaxPower
reserve, linkCapacity, mustRun, thermalModulation).}

\item{writeAllSimulations}{\code{boolean}, write all simulations of your antares study.}

\item{nbCores}{\code{numeric}, number of cores to use, only used if writeAllSimulations is TRUE}

\item{removeVirtualAreas}{\code{boolean}, remove virtual areas, see \link[antaresRead]{removeVirtualAreas}}

\item{storageFlexibility}{\code{character or list}, see \link[antaresRead]{removeVirtualAreas}}

\item{production}{\code{character or list}, see \link[antaresRead]{removeVirtualAreas}}

\item{reassignCosts}{\code{boolean or list}, see \link[antaresRead]{removeVirtualAreas}}

\item{newCols}{\code{boolean or list}, see \link[antaresRead]{removeVirtualAreas}}

\item{overwrite}{\code{boolean or list}, overwrite old file}

\item{supressMessages}{\code{boolean}, supress messages from \link[antaresRead]{readAntares} and \link[antaresRead]{removeVirtualAreas}}
}
\description{
Convert antares output to h5 file
}
\examples{

\dontrun{
# Write simulation one by one
setSimulationPath("C:/Users/MyUser/Mystudy", 1)
writeAntaresH5(path="PATH_TO_YOUR_STUDY")

# Write all simulations
setSimulationPath("C:/Users/MyUser/Mystudy")
writeAntaresH5(path="PATH_TO_YOUR_STUDY", writeAllSimulations = TRUE)

# Choose timestep to write
setSimulationPath("C:/Users/MyUser/Mystudy", 1)
writeAntaresH5(path="PATH_TO_YOUR_STUDY", timeSteps = "hourly")

# Write with additionnal information
writeAntaresH5(path="PATH_TO_YOUR_STUDY", timeSteps = "hourly",
   misc = TRUE, thermalAvailabilities = TRUE,
   hydroStorage = TRUE, hydroStorageMaxPower = TRUE, reserve = TRUE,
   linkCapacity = TRUE, mustRun = TRUE, thermalModulation = TRUE)

# Write all data with a shorcut 
writeAntaresH5(path="PATH_TO_YOUR_STUDY", allData = TRUE)

#Remove virtuals areas

writeAntaresH5(path="PATH_TO_YOUR_STUDY", timeSteps = "hourly", overwrite = TRUE,
               writeMcAll = FALSE, removeVirtualAreas = TRUE,
               storageFlexibility =  "psp in-2",
               production =  NULL, reassignCosts =FALSE, newCols = TRUE)
               
#Remove virtuals areas more than one call
writeAntaresH5(
               path="PATH_TO_YOUR_STUDY", 
               timeSteps = "hourly", 
               overwrite = TRUE,
               writeMcAll = FALSE, 
               removeVirtualAreas = TRUE, 
               storageFlexibility = list("psp out", "psp in-2"),
               production = list(NULL, NULL), 
               reassignCosts = list(TRUE, FALSE), 
               newCols = list(FALSE, TRUE)
               )


}
}
