% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set_f.R
\name{set_f}
\alias{set_f}
\title{Specify function.}
\usage{
set_f(f, ..., npar, lower = -Inf, upper = Inf, iterlim = NULL, check = FALSE)
}
\arguments{
\item{f}{A function to be optimized, returning a single numeric value.
Its first argument should be a numeric vector of length \code{npar}.
Additional arguments can be specified via the \code{...} argument.
Gradient or Hessian of \code{f} can be specified via attributes
\code{gradient} and \code{hessian} for the function value.
They are used for optimization if specified.}

\item{...}{Additional arguments to be passed to \code{f}.}

\item{npar}{The number of variables of \code{f}.}

\item{lower}{Lower bounds on the variables, which can be a single numeric value
(a joint bound for all parameters) or a numeric vector of length \code{npar}
(for individual bounds).}

\item{upper}{Upper bounds on the variables, analogue to \code{lower}.}

\item{iterlim}{The maximum number of iterations for the numerical optimizer for each
sub-problem. No limit per default.}

\item{check}{If \code{TRUE} checks the configuration.
This will take at most 20 seconds in most cases.
Set to \code{FALSE} if you are confident about the configuration to save
computation time.}
}
\value{
An object of class \code{ao_f}.
}
\description{
This function specifies the function to be optimized.
}
\examples{
himmelblau <- function(x) (x[1]^2 + x[2] - 11)^2 + (x[1] + x[2]^2 - 7)^2
set_f(f = himmelblau, npar = 2, lower = -5, upper = 5)
}
