\name{predict-methods}
\docType{methods}
\alias{predict-methods}
\alias{predict,ANY-method}
\alias{predict,glimML-method}
\alias{predict,glimQL-method}

\title{Methods for Function "predict" in Package "aod"}

\description{\dQuote{predict} methods for fitted models generated by functions in package \pkg{aod}.}

\usage{
  \S4method{predict}{glimML}(object, newdata = NULL, 
    type = "response", se.fit = FALSE, \dots)
  \S4method{predict}{glimQL}(object, newdata = NULL, 
    type = c("response", "link"), se.fit = FALSE, \dots)
  }
  
\arguments{
  \item{object}{A fitted model of formal class \dQuote{glimML} (functions \code{betabin} or \code{negbin}) or 
    \dQuote{glimQL} (functions \code{quasibin} or \code{quasipois}).}
  \item{newdata}{A data.frame providing all the explanatory variables necessary for predictions.}
  \item{type}{A character string indicating the scale on which predictions are made: either \dQuote{response} for 
    predictions on the observation scale, or \dQuote{link} for predictions on the scale of the link (logit, cloglog 
    or log.}
  \item{se.fit}{A logical scalar indicating whether pointwise standard errors should be computed for the predictions.}
  \item{\dots}{Other arguments passed to methods.}
  }

\section{Methods}{
  \describe{
    \item{ANY}{Generic function: see \code{\link[stats]{predict}}.}
    \item{glimML}{Compute predictions for models of formal class \dQuote{glimML}, presently generated 
      by functions \code{\link{betabin}} and \code{\link{negbin}}. See the examples for these functions.} 
    \item{glimQL}{Compute predictions for models of formal class \dQuote{glimQL}, presently generated by the
      functions \code{\link{quasibin}} and \code{\link{quasibin}}. See the examples for these functions.} 
    }
  }

\seealso{\code{\link{predict.glm}}}

\keyword{methods}
