% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/aoristic.density.R
\name{aoristic.density}
\alias{aoristic.density}
\title{aoristic graph by grid count}
\usage{
aoristic.density(spdf, h = 0.01, n = 128, probs = 0.99,
  output = "output")
}
\arguments{
\item{spdf}{spatial point data frame produced from aoristic.spdf}

\item{h}{h parameter for the function kde2d (default=0.01); std. dev.}

\item{n}{n parameter for the function kde2d (default=128); No. of cells in xy directions}

\item{probs}{percentile to be identified as hot spots for the function quantile (default=0.99)}

\item{output}{a character representing the name of an output folder (the folder will be generated in the current working directory; default name = output)}
}
\value{
kml file
}
\description{
aoristic graph by grid count
}
\examples{
\donttest{
data(aoristic)
data.spdf <- aoristic.spdf(data=arlington,
   DateTimeFrom="DateTimeFrom", DateTimeTo="DateTimeTo",
   lon="lon", lat="lat")
aoristic.density(spdf=data.spdf)
}
}
\references{
Ratcliffe, J. H. (2002). Aoristic Signatures and the Spatio-Temporal Analysis of High Volume Crime Patterns. Journal of Quantitative Criminology, 18(1), 23-43.
}

